% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.variable.names.r
\name{get.variable.names}
\alias{get.variable.names}
\title{This function helps the user save a lot of time in building a data table containing the original PSID variable codes (e.g. ER30046) for 
each desired year and checks on the psidonline web site in which years a variable is available or not. Information is obtained on 
https://simba.isr.umich.edu/VS/s.aspx.}
\usage{
get.variable.names(vars, years, scrape_name = F, varnames = NULL)
}
\arguments{
\item{vars}{character vector contains the original PSID variable codes of type ER30046.}

\item{years}{numeric vector contains the waves for which the user wants to retrieve the original variable codes.}

\item{scrape_name}{logical indicating whether to retrieve the original variable names (T) or not (F) (e.g. age_of_individual for ER30046).}

\item{varnames}{character vector contains customized variable names; applied if scrape_name set to F and must be of same length as vars.

Note that, in the list of variables provided, one could include a variable code from year y and a variable code from year y'. This is 
allowed and irrelevant to the functioning of the function. Only remark: if the codes refer to the same variable, then the same variable will
show up twice in the output table.

- If scrape_name equals TRUE, then the function recovers the variable names from the online dictionary and edits them to avoid the presence
of special characters such as "/", "#" or "-". The dictionary names suggested by psidonline might be long and cryptic and are NOT always
consistent over years (even if the underlying variable is consistent).
- If the vector varnames is provided and scrape_name equals FALSE, then the function names the variables after the user-provided labels;
varnames must be of the same length as input vector vars.

Here is shown how to obtain the ind and fam data tables used in the main example function. In this example, the function is required to
scrape names from psidonline.

years=c(1968:1997, seq(from=1999, to=2011, by=2))
i <- c("ER30046", "ER30052", "ER30066") # Variable original names for the 1970 wave
f <- c("V1567", "V1514") # Variable original names for the 1970 wave
ind <- get.variable.names(i, years, scrape_name=T)
fam <- get.variable.names(f, years, scrape_name=T)

> head(ind)
     year age_of_individual grade_finished individual_weight
1968 1968           ER30004        ER30010           ER30019
1969 1969           ER30023             NA           ER30042
1970 1970           ER30046        ER30052           ER30066
1971 1971           ER30070        ER30076           ER30090
1972 1972           ER30094        ER30100           ER30116
1973 1973           ER30120        ER30126           ER30137

> head(fam)
     year heads_avg_hrly_ern tot_fu_mon_inc_ov414
1968 1968               V337                  V81
1969 1969               V871                 V529
1970 1970              V1567                V1514
1971 1971              V2279                V2226
1972 1972              V2906                V2852
1973 1973              V3275                V3256}
}
\description{
The function build.panel requires the user to input a table containing the original PSID variable codes. However, this requires looking up
the unique variable identifier for each different wave: for instance, ER30046 stands for age of individual in 1970, while ER30070 for age of
individual in 1971. If the user wants to build a long panel, looking up EACH variable code for EACH wave manually takes a long time. This 
function simplifies the user's life by requiring to provide a list with the original variable codes from one wave only. It then 
automatically looks up the corresponding variable codes for the same variable in other waves, if available. For instance, if the user  
includes the code ER30046 (age in 1970) in the list and declares that the panel should span from 1970 to 1971, then the function will 
return a table containing the original PSID codes for the variable "age of individual" for all desired years, in this case ER30046 (1970)
and ER30070 (1971).
}
\details{
Arguments:
}
