% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S3method.R
\name{kruskal_wallis_test}
\alias{kruskal_wallis_test}
\alias{kruskal_wallis_test.numeric}
\alias{kruskal_wallis_test.formula}
\title{Kruskal-Wallis Test}
\usage{
kruskal_wallis_test(x, ...)

\method{kruskal_wallis_test}{numeric}(x, grp, na.rm = FALSE,
  pseudoranks = TRUE, ...)

\method{kruskal_wallis_test}{formula}(formula, data, na.rm = FALSE,
  pseudoranks = TRUE, ...)
}
\arguments{
\item{x}{numeric vector containing the data}

\item{...}{further arguments are ignored}

\item{grp}{factor specifying the groups}

\item{na.rm}{a logical value indicating if NA values should be removed}

\item{pseudoranks}{logical value indicating if pseudo-ranks or ranks should be used}

\item{formula}{optional formula object}

\item{data}{optional data.frame of the data}
}
\value{
Returns an object of class 'pseudorank'
}
\description{
This function calculates the Kruskal-Wallis test using pseudo-ranks under the null hypothesis H0F: F_1 = ... F_k.
}
\examples{
x = c(1, 1, 1, 1, 2, 3, 4, 5, 6)
grp = as.factor(c('A','A','B','B','B','D','D','D','D'))

# calculate Kruskal-Wallis test using pseudo-ranks
kruskal_wallis_test(x, grp, na.rm = FALSE, pseudoranks = TRUE)
}
\references{
Brunner, E., Bathke, A.C., and Konietschke, F. (2018a). Rank- and Pseudo-Rank Procedures for Independent Observations in Factorial Designs - Using R and SAS. Springer Series in Statistics, Springer, Heidelberg. ISBN: 978-3-030-02912-8.
}
\keyword{export}
