% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kruskal_wallis.R
\name{kruskal_wallis_internal}
\alias{kruskal_wallis_internal}
\title{Hettmansperger-Norton Trend Test for k-Samples}
\usage{
kruskal_wallis_internal(data, group, na.rm, formula = NULL,
  pseudoranks = TRUE, ...)
}
\arguments{
\item{data}{numeric vector containing the data}

\item{group}{factor specifying the groups}

\item{na.rm}{a logical value indicating if NA values should be removed}

\item{formula}{formula object}

\item{pseudoranks}{logical value indicating if pseudo-ranks or ranks should be used}

\item{...}{further arguments are ignored}
}
\value{
Returns a data.frame with the results
}
\description{
This function calculates the Kruskal-Wallis test using pseudo-ranks under the null hypothesis H0F: F_1 = ... F_k.
}
\examples{
x = c(1, 1, 1, 1, 2, 3, 4, 5, 6)
grp = as.factor(c('A','A','B','B','B','D','D','D','D'))

# calculate Kruskal-Wallis test using pseudo-ranks
kruskal_wallis_test(x, grp, na.rm = FALSE, pseudoranks = TRUE)
}
\references{
Brunner, E., Bathke, A.C., and Konietschke, F. (2018a). Rank- and Pseudo-Rank Procedures for Independent Observations in Factorial Designs - Using R and SAS. Springer Series in Statistics, Springer, Heidelberg. ISBN: 978-3-030-02912-8.

Hettmansperger, T. P., & Norton, R. M. (1987). Tests for patterned alternatives in k-sample problems. Journal of the American Statistical Association, 82(397), 292-299
}
\keyword{internal}
