% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataComb.R
\name{dataComb}
\alias{dataComb}
\title{A generic function for cleaning data ready for analysis}
\usage{
dataComb(CFM, DC, id = NULL, trt = NULL, cfmOb = FALSE)
}
\arguments{
\item{CFM}{a model object supplied to pscfit}

\item{DC}{a dataset including covariates to match the CFM}

\item{id}{to specify which observations in the data cohort should be evaluated.  Defualts to 'NULL' i.e all observations}

\item{trt}{used to specify multiple treatment effects. Defaults to NULL}

\item{cfmOb}{used to specify if a CFM object is supplies as the counter factual model}
}
\value{
datComb returns a list containing objects which detial the components of both the
  Counter Factual Model (CFM) and the Data Cohort (DC) the required exported components
  of the model and a cleaned data cohort.
}
\description{
A generic function for cleaning data ready for analysis
}
\examples{
bin.mod <- psc::bin.mod
data <- psc::data
dc <- dataComb(bin.mod,data)
}
