% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proxy.R
\name{simil}
\alias{simil}
\alias{dist}
\title{Compute similarity/distance between rows or columns of large matrices}
\usage{
simil(x, y = NULL, margin = 1, method = c("cosine", "correlation",
  "jaccard", "ejaccard", "dice", "edice", "hamman", "simple matching",
  "faith"), min_simil = NULL, rank = NULL, digits = 14)

dist(x, y = NULL, margin = 1, method = c("euclidean", "chisquared",
  "hamming", "kullback", "manhattan", "maximum", "canberra", "minkowski"),
  p = 2, digits = 14)
}
\arguments{
\item{x}{\link{Matrix} object}

\item{y}{if a \link{matrix} or \link{Matrix} object is provided, proximity
between documents or features in \code{x} and \code{y} is computed.}

\item{margin}{integer indicating margin of similarity/distance computation. 1
indicates rows or 2 indicates columns.}

\item{method}{method to compute similarity or distance}

\item{min_simil}{the minimum similarity value to be recoded.}

\item{rank}{an integer value specifying top-n most similarity values to be
recorded.}

\item{digits}{determines rounding of small values towards zero. Use
primarily to correct rounding errors in C++. See \link{zapsmall}.}

\item{p}{weight for minkowski distance}
}
\description{
Fast similarity/distance computation function for large sparse matrices. You
can floor small similarity value to to save computation time and storage
space by an arbitrary threashold (\code{min_simil}) or rank (\code{rank}).
Please increase the numbner of threads for better perfromance using
\code{\link[RcppParallel]{setThreadOptions}}.
}
\examples{
mt <- Matrix::rsparsematrix(100, 100, 0.01)
simil(mt, method = "cosine")[1:5, 1:5]
mt <- Matrix::rsparsematrix(100, 100, 0.01)
dist(mt, method = "euclidean")[1:5, 1:5]
}
\seealso{
zapsmall
}
