% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/minsorting.R
\name{minsorting}
\alias{minsorting}
\title{Assess settling equivalence of detrital components}
\usage{
minsorting(X, dens, sname = NULL, phi = 2, sigmaphi = 1,
  medium = "freshwater", from = -2.25, to = 5.5, by = 0.25)
}
\arguments{
\item{X}{an object of class \code{compositional}}

\item{dens}{a vector of mineral and rock densities}

\item{sname}{sample name if unspecified, the first sample of the dataset will be used}

\item{phi}{the mean grain size of the sample in Krumbein's phi units}

\item{sigmaphi}{the standard deviation of the grain size distirbution, in phi units}

\item{medium}{the transport medium, one of either "air", "freshwater" or "seawater"}

\item{from}{the minimum grain size to be evaluated, in phi units}

\item{to}{the maximum grain size to be evaluated, in phi units}

\item{by}{the grain size interval of the output table, in phi units}
}
\value{
an object of class \code{minsorting}, i.e. a list with two tables:

mfract: the grain size distribution of each mineral (sum of the columns = 1)

mcomp: the composition of each mineral (sum of the rows = 1)
}
\description{
Models grain size distribution of minerals and rock fragments of different densities
}
\examples{
data(endmembers,densities)
distribution <- minsorting(endmembers,densities,sname='ophiolite',phi=2,
                           sigmaphi=1,medium="seawater",by=0.05)
plot(distribution,cumulative=FALSE)
}
\references{
Resentini, A, Malusa, M G and Garzanti, E. "MinSORTING:
An Excel worksheet for modelling mineral grain-size distribution in
sediments, with application to detrital geochronology and
provenance studies." Computers & Geosciences 59 (2013): 90-97.

Garzanti, E, Ando, S and Vezzoli, G. "Settling equivalence of
detrital minerals and grain-size dependence of sediment
composition." Earth and Planetary Science Letters 273.1 (2008):
138-151.
}
\seealso{
restore
}
\author{
Alberto Resentini and Pieter Vermeesch
}
