% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/srd.R
\name{restore}
\alias{restore}
\title{Undo the effect of hydraulic sorting}
\usage{
restore(X, dens, target = 2.71)
}
\arguments{
\item{X}{an object of class \code{compositional}}

\item{dens}{a vector of rock and mineral densities}

\item{target}{the target density (in g/cm3)}
}
\value{
an object of class \code{SRDcorrected}, i.e. an object of class
\code{compositional} which is a daughter of class \code{compositional}
containing the restored composition, plus one additional member called
\code{restoration}, containing the intermediate steps of the SRD correction
algorithm.
}
\description{
Restore the detrital composition back to a specified source rock density (SRD)
}
\examples{
data(Namib,densities)
rescomp <- restore(Namib$PTHM,densities,2.71)
HMcomp <- c("zr","tm","rt","sph","ap","ep","gt",
            "st","amp","cpx","opx")
amcomp <- amalgamate(rescomp,Plag="P",HM=HMcomp,Opq="opaques")
plot(ternary(amcomp),showpath=TRUE)
}
\author{
Alberto Resentini and Pieter Vermeesch
}
\references{
Garzanti E, Ando, S and Vezzoli, G.  "Settling
equivalence of detrital minerals and grain-size dependence of
sediment composition." Earth and Planetary Science Letters 273.1
(2008): 138-151.
}
\seealso{
minsorting
}

