% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/provenance.R
\name{SH.dist}
\alias{SH.dist}
\title{Sircombe and Hazelton distance}
\usage{
SH.dist(x, i, j, c.con = 0)
}
\arguments{
\item{x}{an object of class \code{DZdata}}

\item{i}{index of the first sample}

\item{j}{index of the second sample}

\item{c.con}{smoothing bandwidth of the kernel functional estimate}
}
\description{
Calculates Sircombe and Hazelton's L2 distance between the Kernel
Functional Estimates (KFEs) of two samples with specified
analytical uncertainties
}
\examples{
datfile <- system.file("DZ.csv",package="provenance")
errfile <- system.file("DZerr.csv",package="provenance")
DZ <- read.DZdata(datfile,errfile)
d <- SH.dist(DZ,1,2)
print(d)
}
\author{
Keith Sircombe and Martin Hazelton
}
\references{
Sircombe, K. N., and M. L. Hazelton. "Comparison of
detrital zircon age distributions by kernel functional estimation."
Sedimentary Geology 171.1 (2004): 91-111.
}

