% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assign_missingness.R
\name{assign_missingness}
\alias{assign_missingness}
\title{Assignment of missingness types}
\usage{
assign_missingness(
  data,
  sample,
  condition,
  grouping,
  intensity,
  ref_condition = "control",
  completeness_MAR = 0.7,
  completeness_MNAR = 0.2,
  retain_columns = NULL
)
}
\arguments{
\item{data}{A data frame containing at least the input variables.}

\item{sample}{The column in the data data frame containing the sample name.}

\item{condition}{The column in the data data frame containing the conditions.}

\item{grouping}{The column in the data data frame containing precursor or peptide identifiers.}

\item{intensity}{The column in the data data frame containing intensity values.}

\item{ref_condition}{The condition that is used as a reference for missingness determination. By default \code{ref_condition = "control"}.}

\item{completeness_MAR}{The minimal degree of data completeness to be considered as MAR. Value has to be between 0 and 1, default is 0.7.
It is multiplied with the number of replicates and then adjusted downward. The resulting number is the minimal number of observations for each
condition to be considered as MAR. This number is always at least 1.}

\item{completeness_MNAR}{The maximal degree of data completeness to be considered as MNAR. Value has to be between 0 and 1, default is 0.20.
It is multiplied with the number of replicates and then adjusted downward. The resulting number is the maximal number of observations for one
condition to be considered as MNAR when the other condition is complete.}

\item{retain_columns}{A vector indicating if certain columns should be retained from the input data frame. Default is not retaining
additional columns \code{retain_columns = NULL}. Specific columns can be retained by providing their names (not in quotations marks,
just like other column names, but in a vector).}
}
\value{
A data frame that contains the reference condition paired with each treatment condition. The \code{comparison} column contains the comparison
name for the specific treatment/reference pair. The \code{missingness} column reports the type of missingness.
\itemize{
\item{"complete": }{No missing values for every replicate of this reference/treatment pair for the specific grouping variable.}
\item{"MNAR": }{Missing not at random. All replicates of either the reference or treatment condition have missing values for the specific grouping variable.}
\item{"MAR": }{Missing at random. At least n-1 replicates have missing values for the reference/treatment pair for the specific grouping varible.}
}
}
\description{
The type of missingness (missing at random, missing not at random) is assigned based on the comparison of a reference condition and every other condition.
}
\examples{
\dontrun{
assign_missingness(
  data,
  sample = r_file_name,
  condition = r_condition,
  grouping = eg_precursor_id,
  intensity = normalised_intensity_log2,
  retain_columns = c(pg_protein_accessions)
)
}
}
