% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/baseline.R
\name{baseline}
\alias{baseline}
\title{baseline}
\usage{
baseline(X, wav)
}
\arguments{
\item{X}{a numeric matrix or vector to process (optionally a data frame that
can be coerced to a numerical matrix).}

\item{wav}{optional. A numeric vector of band positions.}
}
\value{
a matrix or vector with the baselined spectra. The resulting matrix
is output with an attribute called \code{baselines} which contain the spectra
of the fitted baselines.

This function is similar to \code{\link{continuumRemoval}} and it might
replace some of its functionality in the future.
}
\description{
\ifelse{html}{\out{<a href='https://www.tidyverse.org/lifecycle/#maturing'><img src='figures/lifecycle-maturing.svg' alt='Maturing lifecycle'></a>}}{\strong{Maturing}}

Fits a baseline to each spectrum in a matrix and removes it from the
corresponding input spectrum. A vector can also be passed to this function.
}
\details{
The baseline function find points lying on the convex hull
of a spectrum, connects the points by linear interpolation and
subtracts the interpolated line (baseline) from the corresponding spectrum.
}
\examples{
data(NIRsoil)
wav <- as.numeric(colnames(NIRsoil$spc))
# plot of the 5 first absorbance spectra
matplot(wav,
  t(NIRsoil$spc[1:5, ]),
  type = "l",
  ylim = c(0, .6),
  xlab = "Wavelength /nm",
  ylab = "Absorbance"
)

bs <- baseline(NIRsoil$spc, wav)
matlines(wav, t(bs[1:5, ]))

fitted_baselines <- attr(bs, "baselines")
matlines(wav, t(fitted_baselines[1:5, ]))
title("Original spectra, baselines and baselined spectra")
}
\seealso{
\code{\link{savitzkyGolay}}, \code{\link{movav}},
\code{\link{gapDer}}, \code{\link{binning}}, \code{\link{continuumRemoval}}
}
\author{
\href{https://orcid.org/0000-0002-5369-5120}{Leonardo Ramirez-Lopez}
with contributions from Mervin Manalili
}
