% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phit.R
\name{phit}
\alias{phit}
\title{Calculate proportionality metric phi.}
\usage{
phit(counts, symmetrize = TRUE)
}
\arguments{
\item{counts}{A data.frame or matrix. A "count matrix" with subjects as rows and features as columns.}

\item{symmetrize}{A logical. If \code{TRUE}, forces symmetry by reflecting the "lower left triangle".}
}
\value{
Returns a \code{propr} object.
}
\description{
\code{phit} returns a \code{propr} object containing a measure of proportionality.
}
\details{
Let d represent any number of features measured across n biological replicates
	subjected to a binary or continuous event E. For example, E could represent case-control
	status, treatment status, treatment dose, or time. This function converts a
	"count matrix" with n rows and d columns into a proportionality matrix of d rows and d
	columns containing phi measurements for each feature pair. One can think of the resultant
	matrix as equivalent to a distance matrix, except that it has no symmetry unless forced.
}
\examples{
randomNum <- sample(1:1000, size = 25 * 10, replace = TRUE)
counts <- matrix(randomNum, nrow = 25, ncol = 10)
phi <- phit(counts, symmetrize = TRUE)
}
\seealso{
\code{\link{propr}}, \code{\link{propr-class}}, \code{\link{perb}}
}

