% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/promote.R
\name{promote.deploy}
\alias{promote.deploy}
\title{Deploy a model to promote's servers}
\usage{
promote.deploy(model_name, confirm = TRUE, custom_image = NULL)
}
\arguments{
\item{model_name}{name of your model}

\item{confirm}{boolean indicating whether to prompt before deploying}

\item{custom_image}{name of the image you'd like your model to use}
}
\description{
This function takes model.predict and creates
a model on promote's servers which can be called from any programming language
via promote's REST API (see \code{\link{promote.predict}}).
}
\examples{
promote.config <- c(
 username = "your username",
 apikey = "your apikey",
 env = "http://sandbox.promotehq.com/"
)
iris$Sepal.Width_sq <- iris$Sepal.Width^2
fit <- glm(I(Species)=="virginica" ~ ., data=iris)

model.predict <- function(df) {
 data.frame("prediction"=predict(fit, df, type="response"))
}
\dontrun{
promote.library("randomForest")
promote.deploy("irisModel")
}
}
\keyword{deploy}
