% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalize.R
\name{norm_plot}
\alias{norm_plot}
\title{Visualize the effect of normalization}
\usage{
norm_plot(
  original,
  normalized,
  type = "box",
  text_size = 10,
  palette = "viridis",
  save = FALSE,
  file_path = NULL,
  file_name = "Norm_plot",
  file_type = "pdf",
  dpi = 80,
  plot_width = 10,
  plot_height = 7
)
}
\arguments{
\item{original}{A \code{raw_df} object (output of \code{\link{create_df}})
containing missing values, or an \code{imp_df} object after
imputing the missing values with \code{impute_na}.}

\item{normalized}{A \code{norm_df} object after normalizing the data frame
provided as \code{original} using \code{normalize_data}.}

\item{type}{Type of plot to generate. Choices are "box" or "density." Default
is \code{"box."}}

\item{text_size}{Text size for plot labels, axis labels etc. Default is
\code{10}.}

\item{palette}{Viridis color palette option for plots. Default is
\code{"viridis"}. See
\code{\link[viridis:viridis]{viridis}}
for available options.}

\item{save}{Logical. If \code{TRUE} saves a copy of the plot in the
directory provided in \code{file_path}.}

\item{file_path}{A string containing the directory path to save the file.}

\item{file_name}{File name to save the plot.
Default is \code{"Norm_plot."}}

\item{file_type}{File type to save the plot.
Default is \code{"pdf"}.}

\item{dpi}{Plot resolution. Default is \code{80}.}

\item{plot_width}{Width of the plot. Default is \code{10}.}

\item{plot_height}{Height of the plot. Default is \code{7}.}
}
\value{
A \code{ggplot2} plot object.
}
\description{
This function visualizes the impact of normalization on
the data
}
\details{
Given two data frames, one with data prior to normalization
(\code{original}), and the other, after normalization (\code{normalized}),
\code{norm_plot} generates side-by-side plots to visualize the effect of
normalization on the protein intensity data.
}
\examples{
\donttest{
## Generate a raw_df object with default settings. No technical replicates.
raw_df <- create_df(
  prot_groups = "https://raw.githubusercontent.com/caranathunge/promor_example_data/main/pg1.txt",
  exp_design = "https://raw.githubusercontent.com/caranathunge/promor_example_data/main/ed1.txt"
)

## Impute missing values in the data frame using the default minProb
## method.
imp_df <- impute_na(raw_df)

## Normalize the imp_df object using the default quantile method
norm_df <- normalize_data(imp_df)

## Visualize normalization using box plots
norm_plot(original = imp_df, normalized = norm_df)

## Visualize normalization using density plots
norm_plot(imp_df, norm_df, type = "density")
}

}
\seealso{
\itemize{\item \code{\link{normalize_data}}
\item \code{create_df}
\item \code{impute_na}
}
}
\author{
Chathurani Ranathunge
}
