% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.projections.R
\name{plot.projections}
\alias{plot.projections}
\alias{add_projections}
\title{Plot projections objects}
\usage{
\method{plot}{projections}(x, ...)

add_projections(p, x, quantiles = c(0.01, 0.05, 0.1, 0.5), ribbon = TRUE,
  boxplots = FALSE, palette = quantile_pal, quantiles_alpha = 1,
  linetype = 1, linesize = 0.5, ribbon_quantiles = NULL,
  ribbon_color = NULL, ribbon_alpha = 0.3, boxplots_color = "#47476b",
  boxplots_alpha = 0.8, outliers = TRUE)
}
\arguments{
\item{x}{A \code{projections} object.}

\item{...}{Further arguments to be passed to \code{add_projections}.}

\item{p}{A previous incidence plot to which projections should be added.}

\item{quantiles}{A vector of quantiles to plot, automatically completed to be
symmetric around the median.}

\item{ribbon}{A logical indicating if a ribbon should be drawn; defaults to
\code{TRUE}.}

\item{boxplots}{A logical indicating if boxplots should be drawn.}

\item{palette}{A color palette to be used for plotting the quantile lines;
defaults to \code{quantile_pal}.}

\item{quantiles_alpha}{A number used to control the transparency of the
quantile lines, from 0 (full transparency) to 1 (full opacity); defaults to
1.}

\item{linetype}{An integer indicating the type of line used for plotting the
quantiles; defaults to 1 for a plain line.}

\item{linesize}{An integer indicating the size of line used for plotting the
quantiles; defaults to 0.5.}

\item{ribbon_quantiles}{A vector of 2 quantiles to be used to determine the
limits of the ribbon; if NULL (default); uses the most extreme quantiles if
available; if quantiles are not provided, the daily range will be used.}

\item{ribbon_color}{Any valid color, used for the ribbon.}

\item{ribbon_alpha}{A number used to control the transparency of the
ribbon, from 0 (full transparency) to 1 (full opacity); defaults to 0.3.}

\item{boxplots_color}{Any valid color, used for the boxplot.}

\item{boxplots_alpha}{A number used to control the transparency of the
boxplots, from 0 (full transparency) to 1 (full opacity); defaults to 0.8.}

\item{outliers}{A logical indicating if outliers should be displayed
alongside the boxplots; defaults to \code{TRUE}.}
}
\description{
The \code{plot} method of \code{projections} objects (output by the function
\code{\link{project}}) shows quantiles of predicted incidence over time. The
function \code{add_projections} can be used to add a similar plot to an
existing \code{incidence} plot. This latter function is piping friendly (see
examples).
}
\examples{

if (require(outbreaks) &&
    require(distcrete) &&
    require(incidence) &&
    require(magrittr)) {

si <- distcrete("gamma", interval = 1L,
                 shape = 0.37,
                 scale = 41.4, w = 0)

i <- incidence(ebola_sim$linelist$date_of_onset)
plot(i)

## add projections after the first 100 days, over 60 days
set.seed(1)
proj <- project(x = i[1:100], R = 2.1, si = si, n_days = 60)

## plotting projections: different options
plot(proj)
plot(proj, quantiles = c(.025, .5)) # 95\% CI
plot(proj, ribbon_color = "red", quantiles = FALSE) # range
plot(proj, ribbon_color = "red", quantiles = FALSE,
     ribbon_quantiles = c(.025, .5))
plot(proj, boxplots = TRUE, quantiles = FALSE, ribbon = FALSE)
plot(proj, boxplots = TRUE, quantiles = FALSE, outliers = FALSE)
plot(proj, linetype = 3)

## adding them to incidence plot
plot(i) \%>\% add_projections(proj)
plot(i[1:160]) \%>\% add_projections(proj)
plot(i[1:160]) \%>\% add_projections(proj, boxplots = FALSE)
plot(i[1:160]) \%>\%
  add_projections(proj, boxplots_alpha = .3, boxplots_color = "red")

## same, with customised quantiles and colors
quantiles <- c(.001, .01, 0.05, .1, .2, .3, .4, .5)
pal <- colorRampPalette(c("#b3c6ff", "#00e64d", "#cc0066"))
plot(i[1:200]) \%>\%
  add_projections(proj, quantiles, palette = pal)

}

}
\seealso{
\code{\link{project}} to generate projections
}
\author{
Thibaut Jombart \email{thibautjombart@gmail.com}
}
