% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getProfiles_optim.R
\name{getProfileSup_optim}
\alias{getProfileSup_optim}
\title{Generic profile sup function computation with optim}
\usage{
getProfileSup_optim(eta, Psi, f, fprime, d, options = NULL)
}
\arguments{
\item{eta}{\eqn{p} dimensional point where the function is to be evaluated}

\item{Psi}{projection matrix of dimensions \code{p x d}}

\item{f}{function to be optimized (takes a vector y of dimension d and returns a real number)}

\item{fprime}{derivative of f (same format, returning a \eqn{d} dimensional vector)}

\item{d}{dimension of the input for f}

\item{options}{a list containing the options to be passed to optim:
\itemize{
\item{\code{par:}}{contains the starting point (a point in dimension d-1)}
\item{\code{lower:} }{the lower bounds for the optimization domain (see optim for details)}
\item{\code{upper:}}{the upper bounds for the optimization domain (see optim for details)}
}}
}
\value{
a real value corresponding to \eqn{max_{x \in D_Psi} f(x)}
}
\description{
Compute profile sup function for an arbitrary matrix \code{Psi} with the L-BFGS-B algorithm of \link[stats]{optim}.
}
\seealso{
\link{getProfileInf_optim}, \link{plotMaxMin}
}
\author{
Dario Azzimonti
}
