% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{compute_paras_hmm}
\alias{compute_paras_hmm}
\title{Compute probabilities from logit scale parameters in HMM}
\usage{
compute_paras_hmm(para_P, para_Q, para_P1)
}
\arguments{
\item{para_P}{\code{K} by \code{K-1} matrix. parameters of state-transition probability matrix}

\item{para_Q}{\code{K} by \code{N-1} matrix. parameters of state-action (emission) probability matrix}

\item{para_P1}{\code{K-1} vector. parameters of initial state probability distribution}
}
\value{
a list of three elements:
\tabular{ll}{
{\code{P}} \tab {\code{K} by \code{K} state-transition probability matrix} \cr
\tab \cr
{\code{Q}} \tab {\code{K} by \code{N} state-action (emission) probability matrix} \cr
\tab \cr
{\code{P1}} \tab {initial state probability vector of length \code{K}} \cr
\tab \cr
}
}
\description{
Compute probabilities from logit scale parameters in HMM
}
\examples{
paras <- sim_hmm_paras(5, 2, return_prob=FALSE)
prob_paras <- compute_paras_hmm(paras$para_P, paras$para_Q, paras$para_P1)

}
\seealso{
\code{\link{compute_PQ_lhmm}}, \code{\link{compute_P1_lhmm}} for computing probabilities in LHMM
}
