% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trace_explorer.R
\name{trace_explorer}
\alias{trace_explorer}
\alias{trace_explorer.eventlog}
\alias{trace_explorer.activitylog}
\title{Trace Explorer}
\usage{
trace_explorer(
  log,
  coverage = NULL,
  n_traces = NULL,
  type = c("frequent", "infrequent"),
  coverage_labels = c("relative", "absolute", "cumulative"),
  abbreviate = TRUE,
  show_labels = TRUE,
  label_size = 3,
  scale_fill = bupaR::scale_fill_discrete_bupaR,
  raw_data = FALSE,
  plotly = FALSE,
  eventlog = deprecated(),
  .abbreviate = deprecated()
)

\method{trace_explorer}{eventlog}(
  log,
  coverage = NULL,
  n_traces = NULL,
  type = c("frequent", "infrequent"),
  coverage_labels = c("relative", "absolute", "cumulative"),
  abbreviate = TRUE,
  show_labels = TRUE,
  label_size = 3,
  scale_fill = bupaR::scale_fill_discrete_bupaR,
  raw_data = FALSE,
  plotly = FALSE,
  eventlog = deprecated(),
  .abbreviate = deprecated()
)

\method{trace_explorer}{activitylog}(
  log,
  coverage = NULL,
  n_traces = NULL,
  type = c("frequent", "infrequent"),
  coverage_labels = c("relative", "absolute", "cumulative"),
  abbreviate = TRUE,
  show_labels = TRUE,
  label_size = 3,
  scale_fill = bupaR::scale_fill_discrete_bupaR,
  raw_data = FALSE,
  plotly = FALSE,
  eventlog = deprecated(),
  .abbreviate = deprecated()
)
}
\arguments{
\item{log}{\code{\link[bupaR:log]{log}}: Object of class \code{\link[bupaR:log]{log}} or derivatives (\code{\link[bupaR:eventlog]{eventlog}}
or \code{\link[bupaR:activitylog]{activitylog}}).}

\item{coverage}{\code{\link{numeric}} (default \code{0.2}): The percentage coverage of the trace to explore. Defaults to \code{0.2} (\code{0.05}) most (in)frequent.}

\item{n_traces}{\code{\link{integer}}: Instead of setting \code{coverage}, an exact number of traces can be set. Should be an \code{\link{integer}} larger than \code{0}.}

\item{type}{\code{\link{character}} (default \code{"frequent"}): \code{"frequent"} traces first, or \code{"infrequent"} traces first?}

\item{coverage_labels}{\code{\link{character}} (default \code{"relative"}): Change the labels to be shown on the right of the process variants.
These can be \code{"relative"} frequency (default), \code{"absolute"}, or \code{"cumulative"}. Multiple labels can be selected at the same time.}

\item{abbreviate}{\code{\link{logical}} (default \code{TRUE}): If \code{TRUE}, abbreviate activity labels.}

\item{show_labels}{\code{\link{logical}} (default \code{TRUE}): If \code{FALSE}, activity labels are not shown.}

\item{label_size}{\code{\link{numeric}} (default \code{3}): Font size of labels.}

\item{scale_fill}{\code{\link{ggplot2}} scale function (default \code{\link[bupaR:scale_fill_discrete_bupaR]{scale_fill_discrete_bupaR}}):
Set color scale. Defaults to \code{\link[bupaR:scale_fill_discrete_bupaR]{scale_fill_discrete_bupaR}}. Replaced with \code{\link[ggplot2:scale_colour_discrete]{scale_fill_discrete}} when more than 26 activities are present.}

\item{raw_data}{\code{\link{logical}} (default \code{FALSE}): Return raw data instead of graph.}

\item{plotly}{\code{\link{logical}} (default \code{FALSE}): Return a \code{\link{plotly}} object, instead of a \code{\link{ggplot2}}.}

\item{eventlog}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}; please use \code{log} instead.}

\item{.abbreviate}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}; please use \code{abbreviate} instead.}
}
\description{
Different activity sequences in the \code{log} can be visualized with \code{\link[=trace_explorer]{trace_explorer()}}. With the \code{type} argument,
it can be used to explore frequent as well as infrequent traces. The \code{coverage} argument specificies how much of the
\code{log} you want to explore. By default it is set at \code{0.2}, meaning that it will show the most (in)frequency traces
covering 20\% of the \code{log}.
}
\section{Methods (by class)}{
\itemize{
\item \code{trace_explorer(eventlog)}: Trace explorer for an \code{\link[bupaR:eventlog]{eventlog}}.

\item \code{trace_explorer(activitylog)}: Trace explorer for an \code{\link[bupaR:activitylog]{activitylog}}.

}}
\examples{
library(processmapR)
library(eventdataR)

patients \%>\%
 trace_explorer(coverage = 0.8)

}
