% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/samp.R
\name{samp}
\alias{samp}
\title{Stratified permanent random number sampling}
\usage{
samp(method, frame, ...)
}
\arguments{
\item{method}{\code{pps} or \code{srs}.}

\item{frame}{Data frame (or data.table or tibble) containing the elements
to sample from.}

\item{...}{Further method-specific arguments.}
}
\value{
A copy of the input data frame together with the boolean variable
\code{sampled}, as well as the numeric variables \code{lambda} and \code{Q}
when pps is used.
}
\description{
Wrapper for stratified simple random sampling (SRS) and
probability-proportional-to-size (PPS) sampling using permanent random
numbers. Can also be used for non-stratified sampling using a dummy stratum
taking the same value for each object.
}
\examples{
dfOut <- samp(
  method = pps,
  frame = ExampleData,
  nsamp = ~nsample,
  stratid = ~stratum,
  prn = ~rands,
  size = ~sizeM
)

dfOut <- samp(
  method = srs,
  frame = ExampleData,
  nsamp = ~nsample,
  stratid = ~stratum,
  prn = ~rands
)
}
\seealso{
\link{prnsamplr}, \link{srs}, \link{pps}, \link{transformprn},
\link{ExampleData}
}
