% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compile.R
\name{compile}
\alias{compile}
\alias{compile.ConservationProblem}
\title{Compile a problem}
\usage{
compile(x, ...)

\method{compile}{ConservationProblem}(x, compressed_formulation = NA, ...)
}
\arguments{
\item{x}{\code{\link[=problem]{problem()}} object.}

\item{...}{not used.}

\item{compressed_formulation}{\code{logical} should the conservation problem
compiled into a compressed version of a planning problem?
If \code{TRUE} then the problem is expressed using the compressed
formulation. If \code{FALSE} then the problem is expressed using the
expanded formulation. If \code{NA}, then the compressed is used unless one
of the constraints requires the expanded formulation. This argument
defaults to \code{NA}.}
}
\value{
A \code{\link[=optimization_problem]{optimization_problem()}} object.
}
\description{
Compile a conservation planning problem into an
mixed integer linear programming problem.
}
\details{
This function might be useful for those interested in understanding
how their conservation planning \code{\link[=problem]{problem()}} is expressed
as a mathematical problem. However, if the problem just needs to
be solved, then the \code{\link[=solve]{solve()}} function should just be used.

\strong{Please note that in nearly all cases, the default argument to
\code{compressed_formulation} should be used}. The only situation where
manually
setting the argument to \code{formulation} is desirable is during testing.
Manually setting the argument to \code{formulation} will at best
have no effect on the problem. At worst, it may result in
an error, a misspecified problem, or unnecessarily long
solve times.
}
\examples{
\dontrun{
# load data
sim_pu_raster <- get_sim_pu_raster()
sim_features <- get_sim_features()

# build minimal conservation problem
p <-
  problem(sim_pu_raster, sim_features) \%>\%
  add_min_set_objective() \%>\%
  add_relative_targets(0.1)

# compile the conservation problem into an optimization problem
o <- compile(p)

# print the optimization problem
print(o)
}
}
