% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_default_solver.R
\name{add_default_solver}
\alias{add_default_solver}
\title{Default solver}
\usage{
add_default_solver(x, ...)
}
\arguments{
\item{x}{\code{\link[=problem]{problem()}} (i.e. \code{\linkS4class{ConservationProblem}}) object.}

\item{...}{arguments passed to the solver.}
}
\value{
Object (i.e. \code{\linkS4class{ConservationProblem}}) with the solver
added to it.
}
\description{
Identify the best solver currently installed on the system and specify that
it should be used to solve a conservation planning \code{\link[=problem]{problem()}}.
Ranked from best to worst, the available solvers that can be used are:
\pkg{gurobi}
(\code{\link[=add_gurobi_solver]{add_gurobi_solver()}}), then
\pkg{Rsymphony} (\code{\link[=add_rsymphony_solver]{add_rsymphony_solver()}}), and finally \pkg{lpsymphony}
(\code{\link[=add_lpsymphony_solver]{add_lpsymphony_solver()}}).
}
\seealso{
\link{solvers}.
}
