% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/penalties.R
\name{penalties}
\alias{penalties}
\title{Conservation problem penalties}
\description{
A penalty can be applied to a conservation planning \code{\link{problem}} to
penalize solutions according to a specific metric. Penalties---unlike
\code{\link{constraints}}---act as an explicit trade-off with the objective
being minimized or maximized (e.g. solution cost when used with
\code{\link{add_min_set_objective}}).
}
\details{
Both penalties and constraints can be used to modify a problem and
  identify solutions that exhibit specific characteristics. Constraints work
  by invalidating solutions that do not exhibit specific characteristics.
  On the other hand, penalties work by specifying trade-offs against the
  main problem objective and are mediated by a penalty factor.

  The following penalties can be added to a conservation planning
  \code{\link{problem}}:

  \describe{

  \item{\code{\link{add_boundary_penalties}}}{Add penalties to a
    conservation problem to favor solutions that have
    planning units clumped together into contiguous areas.}

  \item{\code{\link{add_connectivity_penalties}}}{Add penalties to a
    conservation problem to favor solutions that select
    planning units with high connectivity between them.}

  }
}
\examples{
# load data
data(sim_pu_points, sim_features)

# create basic problem
p1 <- problem(sim_pu_raster, sim_features) \%>\%
      add_min_set_objective() \%>\%
      add_relative_targets(0.2) \%>\%
      add_default_solver()

# create problem with boundary penalties
p2 <- p1 \%>\% add_boundary_penalties(5, 1)

# create connectivity matrix based on spatial proximity
 scm <- as.data.frame(sim_pu_raster, xy = TRUE, na.rm = FALSE)
 scm <- 1 / (as.matrix(dist(scm)) + 1)

# remove weak and moderate connections between planning units to reduce
# run time
scm[scm < 0.85] <- 0

# create problem with connectivity penalties
p3 <- p1 \%>\% add_connectivity_penalties(25, data = scm)
\donttest{
# solve problems
s <- stack(solve(p1), solve(p2), solve(p3))

# plot solutions
plot(s, axes = FALSE, box = FALSE,
     main = c("basic solution", "boundary penalties",
              "connectivity penalties"))
 }
}
\seealso{
\code{\link{constraints}}, \code{\link{decisions}},
 \code{\link{objectives}} \code{\link{portfolios}}, \code{\link{problem}},
 \code{\link{solvers}}, \code{\link{targets}}.
}
