% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/number_of_features.R
\name{number_of_features}
\alias{number_of_features}
\alias{number_of_features,ConservationProblem-method}
\alias{number_of_features,OptimizationProblem-method}
\alias{number_of_features,ZonesRaster-method}
\alias{number_of_features,ZonesCharacter-method}
\alias{number_of_features}
\alias{number_of_features}
\alias{number_of_features}
\alias{number_of_features}
\alias{number_of_features}
\title{Number of features}
\usage{
number_of_features(x)

\S4method{number_of_features}{ConservationProblem}(x)

\S4method{number_of_features}{OptimizationProblem}(x)

\S4method{number_of_features}{ZonesRaster}(x)

\S4method{number_of_features}{ZonesCharacter}(x)
}
\arguments{
\item{x}{\code{\link{ConservationProblem-class}},
\code{\link{OptimizationProblem-class}} or \code{\link{Zones}} object.}
}
\value{
\code{integer} number of features.
}
\description{
Extract the number of features in an object.
}
\examples{
# load data
data(sim_pu_raster, sim_features)

# create problem
p <- problem(sim_pu_raster, sim_features) \%>\%
     add_min_set_objective() \%>\%
     add_relative_targets(0.2) \%>\%
     add_binary_decisions()

# print number of features
print(number_of_features(p))
}
