% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_corridor_constraints.R
\name{add_corridor_constraints}
\alias{add_corridor_constraints}
\title{Add corridor constraints}
\usage{
add_corridor_constraints(x, connectivities, thresholds, ...)
}
\arguments{
\item{x}{\code{\link{ConservationProblem-class}} object.}

\item{connectivities}{\code{object} used to calculate the the connectivity
between planning units. See the Details section for more information.}

\item{thresholds}{\code{numeric} value representing the minimum
connectivity required between planning units for them to be
considered connected for a given feature. Threshold values
are expressed as a proportion of the total range of connectivity
observed among all planning units for each feature. If a higher
threshold is used, then planning units with lower conductances,
and in turn, lower connectivity will not be considered
to have strong enough connectivity to form corridors to link
planning units. If \code{thresholds} is a single number then it is used
as the threshold for each feature. Otherwise, if \code{threshold} is a
\code{vector} then it specifies the threshold for each feature.}

\item{...}{additional arguments passed to \code{\link{fast_extract}} if
the planning units in argument to \code{x} inherit from a
\code{\link[raster]{RasterStack-class}} object.}
}
\value{
\code{\link{ConservationProblem-class}} object.
}
\description{
It is important to maintain connectivity throughout a reserve network.
However, some areas are more difficult for species to traverse then other
areas. As a consequence, even though a reserve may protect a contiguous
section of land, some species may not be able to disperse throughout
the network if some of the land is a high barrier to dispersal. This
function adds constraints to ensure that all planning units used to
represent features in the conservation problem are connected by planning
units that have high connectivity.
}
\details{
This function adds constraints to a conservation planning problem to ensure
  that all planning units used to represent a given feature are connected to
  each other. To achieve this, each planning unit is associated with
  conductance values that describe the ease at which individuals from
  each feature can disperse through it. Higher conductance values indicate
  that individuals can move planning units with greater ease. The
  connectivity between two planning units is calculated as the average
  conductance of the two planning units. After the connectivity values have
  been calculated, the threshold is applied to determine which planning
  units are "connected enough" to be used for linking planning units
  occupied by conspecifics. \strong{Adding these constraints to a problem
  will dramatically increase the amount of time required to solve it.}

  The argument to \code{y} can be used to specify the
  the connectivity between different planning units in several different
  ways:
 \describe{
   \item{\code{character} \code{vector}}{If the planning units in
     argument to \code{x} inherit from a \code{\link[sp]{Spatial-class}}
     object then the argument to code{y} can refer to the
     names of the columns in the attribute table that contain the
     conductance values for each planning unit for each feature.
     It is assumed that the order of the column names in argument to
     \code{y} matches the order of the features in the
     argument to \code{x}.}

   \item{\code{\link[raster]{RasterStack-class}} object}{Each band
     corresponds
     to each feature in the argument to \code{x}. The cells in each band
     denote the conductance of an area. For a given feature, the
     conductance of each planning unit is calculated by overlaying the
     planning units in argument to code{x} with the raster data in
     argument to \code{conductance}. Note that
     if the planning units in argument to \code{x} inherit from a
     \code{\link[raster]{Raster-class}} object, then the argument to
     code{conductance} must have the same spatial properties as the
     planning units (i.e. coordinate system, extent, resolution).}

  \item{\code{list} of \code{\link[Matrix]{dsCMatrix-class}} matrices}{
     Each element in the list corresponds to a different feature. Each
     row and column refers to a different planning unit, and the cell
     values denote the connectivity between the two planning units. Note
     that the connectivity between planning units is assumed to be
     symmetric.}
 }
}
\examples{
# load data
data(sim_pu_raster, sim_features)

# create a basic problem
p1 <- problem(sim_pu_raster, sim_features) \%>\%
      add_min_set_objective() \%>\%
      add_relative_targets(0.1)

# create problem with added corridor constraints to ensure that
# planning units used to represent features are connected by
# planning units with habitat that is suitable for that feature
p2 <- p1 \%>\% add_corridor_constraints(sim_features, 0.5)
\donttest{
# solve problems
s <- stack(solve(p1), solve(p2))

# plot solutions
plot(s, main = c("basic solution", "solution with corridors"), axes = FALSE,
     box = FALSE)

}

}
\seealso{
\code{\link{constraints}}.
}
