% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getCost.R
\name{getCost}
\alias{getCost}
\title{Extract cost values}
\usage{
getCost(x)
}
\arguments{
\item{x}{\linkS4class{solution} or \linkS4class{portfolio} object.}
}
\value{
\link{data.frame}.
}
\description{
Provides the sum of costs to actions and monitoring applied in a solution.
}
\details{
The cost value is calculated as the sum of all the individual costs
of actions and monitoring carried out in each of the planning units. This can be expressed
mathematically for a set of planning units
\eqn{I} indexed by \eqn{i}, and
a set of threats \eqn{K} indexed by \eqn{k} as:

\deqn{
actions = \sum_{i \in I}\sum_{k \in K_i} x_{ik} c_{ik}
}

\deqn{
monitoring = \sum_{i \in I} x_{i \cdot} c^{'}_{i}
}
Where, \eqn{x_{ik}} is the decisions variable that specify
whether an action has been selected to abate threat \eqn{k} in planning unit
\eqn{i} (1) or not (0), \eqn{c_{ik}} is the action cost to abate threat \eqn{k}
in planning unit \eqn{i} and  \eqn{c^{'}_{i}} is the monitoring cost of
planning unit \eqn{i}. The cost of monitoring is applied to all planning units
where some type of action has been selected (conservation action, to abate threats
or connectivity).

Note that there is an action per threat, so it is assumed that the index of
the threat coincides with the index of the action used to abate it.
}
\examples{
\donttest{
# set seed for reproducibility
set.seed(14)

## Load data
data(sim_pu_data, sim_features_data, sim_dist_features_data,
sim_threats_data, sim_dist_threats_data, sim_sensitivity_data,
sim_boundary_data)

## Create data instance
problem_data <- inputData(
  pu = sim_pu_data, features = sim_features_data, dist_features = sim_dist_features_data,
  threats = sim_threats_data, dist_threats = sim_dist_threats_data,
  sensitivity = sim_sensitivity_data, boundary = sim_boundary_data
)

## Create optimization model
problem_model <- problem(x = problem_data)

## Solve the optimization model
s <- solve(a = problem_model, time_limit = 2, output_file = FALSE, cores = 2)

## Get costs
getCost(s)
}
}
