% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check.R
\name{check_pdist}
\alias{check_pdist}
\title{Check if a function is a valid cumulative distribution function (CDF)}
\usage{
check_pdist(pdist, D, ...)
}
\arguments{
\item{pdist}{Distribution function (CDF). The package can identify base R
distributions for potential analytical solutions. For non-base R functions,
users can apply \code{\link[=add_name_attribute]{add_name_attribute()}} to yield properly tagged
functions if they wish to leverage the analytical solutions.}

\item{D}{Maximum delay (truncation point). If finite, the distribution is
truncated at D. If set to Inf, no truncation is applied. Defaults to Inf.}

\item{...}{Additional arguments to be passed to pdist}
}
\value{
NULL. The function will stop execution with an error message if
pdist is not a valid CDF.
}
\description{
This function tests whether a given function behaves like a valid CDF by
checking if it's monotonically increasing and bounded between 0 and 1.
}
\examples{
check_pdist(pnorm, D = 10)
}
\seealso{
Distribution checking functions
\code{\link{check_dprimary}()},
\code{\link{check_truncation}()}
}
\concept{check}
