% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pcens.R
\name{new_pcens}
\alias{new_pcens}
\title{S3 class for primary event censored distribution computation}
\usage{
new_pcens(
  pdist,
  dprimary,
  dprimary_args,
  pdist_name = lifecycle::deprecated(),
  dprimary_name = lifecycle::deprecated(),
  ...
)
}
\arguments{
\item{pdist}{Distribution function (CDF). The package can identify base R
distributions for potential analytical solutions. For non-base R functions,
users can apply \code{\link[=add_name_attribute]{add_name_attribute()}} to yield properly tagged
functions if they wish to leverage the analytical solutions.}

\item{dprimary}{Function to generate the probability density function
(PDF) of primary event times. This function should take a value \code{x} and a
\code{pwindow} parameter, and return a probability density. It should be
normalized to integrate to 1 over [0, pwindow]. Defaults to a uniform
distribution over [0, pwindow]. Users can provide custom functions or use
helper functions like \code{dexpgrowth} for an exponential growth distribution.
See \code{primary_dists.R} for examples. The package can identify base R
distributions for potential analytical solutions. For non-base R functions,
users can apply \code{\link[=add_name_attribute]{add_name_attribute()}} to yield properly tagged
functions if they wish to leverage analytical solutions.}

\item{dprimary_args}{List of additional arguments to be passed to
dprimary. For example, when using \code{dexpgrowth}, you would
pass \code{list(min = 0, max = pwindow, r = 0.2)} to set the minimum, maximum,
and rate parameters}

\item{pdist_name}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} this argument will be
ignored in future versions; use \code{\link[=add_name_attribute]{add_name_attribute()}} on \code{pdist}
instead}

\item{dprimary_name}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} this argument will be
ignored in future versions; use \code{\link[=add_name_attribute]{add_name_attribute()}} on \code{dprimary}
instead}

\item{...}{Additional arguments to be passed to pdist}
}
\value{
An object of class \verb{pcens_\{pdist_name\}_\{dprimary_name\}}. This
contains the primary event distribution, the delay distribution, the
delay distribution arguments, and any additional arguments. It can be
used with the \code{pcens_cdf()} function to compute the primary event censored
cdf.
}
\description{
S3 class for primary event censored distribution computation
}
\seealso{
Low level primary event censored distribution objects and methods
\code{\link{pcens_cdf}()},
\code{\link{pcens_cdf.default}()},
\code{\link{pcens_cdf.pcens_pgamma_dunif}()},
\code{\link{pcens_cdf.pcens_plnorm_dunif}()},
\code{\link{pcens_cdf.pcens_pweibull_dunif}()}
}
\concept{pcens}
