% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deployment.R
\name{create_deployment_app}
\alias{create_deployment_app}
\title{[BETA] Create a new deployment for an application.}
\usage{
create_deployment_app(
  project_id,
  name,
  git_url,
  git_branch,
  type,
  broker,
  app_cpu = 1,
  app_ram = "128Mi",
  app_replica_count = 1,
  env_vars = list(),
  access_type = "fine_grained",
  description = NULL
)
}
\arguments{
\item{project_id}{id of the project, can be obtained with get_projects().}

\item{name}{name of the deployment.}

\item{git_url}{url of the git repository than contains the app to be deployed.}

\item{git_branch}{branch of the git repository than contains the app to be deployed.}

\item{type}{type of language in which the app is written among "r", "python" or "node".}

\item{broker}{broker of the git repository (gitlab, github) that contains the application.}

\item{app_cpu}{number of CPU that is allocated for the application deployment (1 default, 2 or 4)}

\item{app_ram}{quantity of RAM that is allocated for the application deployment (128Mi default, 256Mi, 512Mi, 1Gi, 2Gi, 4Gi or 8Gi)}

\item{app_replica_count}{number of replica allocated for the application deployment (1 default, 2, 3, 4, 5, 6, 7, 8, 9 or 10)}

\item{env_vars}{list of environment variables (optional).}

\item{access_type}{type of access of the deployment among "fine_grained" (project defined, default), "private" (instance) or "public" (everyone).}

\item{description}{description of the deployment (optional).}
}
\value{
list - parsed content of the deployment.
}
\description{
[BETA] Create a new deployment for an application.
}
