% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/winther_ptp.R
\name{calculate_winther_2020_rf_cl_ptp}
\alias{calculate_winther_2020_rf_cl_ptp}
\title{Calculate 2020 Winther RF-CL PTP model for obstructive CAD}
\usage{
calculate_winther_2020_rf_cl_ptp(
  age,
  sex,
  chest_pain_type,
  have_dyspnoea,
  have_family_history,
  have_smoking_history,
  have_dyslipidemia,
  have_hypertension,
  have_diabetes,
  allow_na_symptom_score = TRUE,
  max_na_num_of_rf = 0
)
}
\arguments{
\item{age}{Input numeric value to indicate the age of the patient.}

\item{sex}{Input characters (female, male) to indicate the sex of the patient.
\itemize{
  \item female
  \item male
}}

\item{chest_pain_type}{Input characters (no chest pain, typical, atypical, nonanginal)
to indicate the chest pain characteristics of the patient.
\itemize{
  \item no chest pain stands for the patient having no chest pain.
  \item typical stands for the patient having typical chest pain.
  \item atypical stands for the patient having atypical chest pain.
  \item nonanginal stands for the patient having nonanginal or non-specific chest pain.
}}

\item{have_dyspnoea}{Input characters (no, yes) to indicate if the patient
only has dyspnoea symptoms.
\itemize{
  \item no stands for not having dyspnoea symptoms.
  \item yes stands for having dyspnoea symptoms.
}}

\item{have_family_history}{Input characters (no, yes) to indicate if the patient
has a family history of CAD.
\itemize{
  \item no stands for not having a family history of CAD.
  \item yes stands for having a family history of CAD.
}}

\item{have_smoking_history}{Input characters (no, yes) to indicate if the patient
has a smoking history (current or past smoker).
\itemize{
  \item no stands for not having a smoking history (non-smoker).
  \item yes stands for having a smoking history (current or past smoker).
}}

\item{have_dyslipidemia}{Input characters (no, yes) to indicate if the patient
has dyslipidemia.
\itemize{
  \item no stands for not having dyslipidemia.
  \item yes stands for having dyslipidemia.
}}

\item{have_hypertension}{Input characters (no, yes) to indicate if the patient
has hypertension.
\itemize{
  \item no stands for not having hypertension.
  \item yes stands for having hypertension.
}}

\item{have_diabetes}{Input characters (no, yes) to indicate if the patient
has diabetes.
\itemize{
  \item no stands for not having diabetes.
  \item yes stands for having diabetes.
}}

\item{allow_na_symptom_score}{A logical evaluating to \code{TRUE} or \code{FALSE} indicating whether we can
allow \code{chest_pain_type} or \code{have_dyspnoea} to be \code{NA} when calculating the score}

\item{max_na_num_of_rf}{Input integer 0 to 5 to indicate the maximum number of
missing risk factors to tolerate before outputting an \code{NA}.
Default: 0}
}
\value{
A numeric value representing the patient's PTP for obstructive CAD
based on the 2020 Winther et. al. Risk Factor-Weighted Clinical Likelihood (RF-CL) model.
}
\description{
This function returns a patient's
pre-test probability (PTP) of obstructive
coronary artery disease based on the
2020 Winther et. al. Risk Factor-Weighted Clinical Likelihood (RF-CL) model.
}
\details{
The predictive model is based on > 40000 symptomatic
patients from 2008 to 2017 from 13 hospitals in Western Denmark. These
patients are registered under the Western Denmark Heart Registry.
}
\examples{
# 40 year old Male with nonanginal chest pain
calculate_winther_2020_rf_cl_ptp(
    age = 40,
    sex = "male",
    chest_pain_type = "no chest pain",
    have_dyspnoea = "no",
    have_family_history = "no",
    have_smoking_history = "no",
    have_dyslipidemia = "no",
    have_hypertension = "no",
    have_diabetes = "no",
    allow_na_symptom_score = TRUE,
    max_na_num_of_rf = 0
)
}
