% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dcs_ptp.R
\name{calculate_dcs_1993_vascular_disease_index}
\alias{calculate_dcs_1993_vascular_disease_index}
\title{Calculate The Vascular Disease Index For Duke Clinical Score 1993}
\usage{
calculate_dcs_1993_vascular_disease_index(
  have_peripheral_vascular_disease,
  have_cerebrovascular_disease,
  have_carotid_bruits,
  max_na = 0
)
}
\arguments{
\item{have_peripheral_vascular_disease}{Input characters (no, yes) to indicate if the patient
has peripheral vascular disease.
\itemize{
  \item no stands for not having peripheral vascular disease.
  \item yes stands for having peripheral vascular disease.
}}

\item{have_cerebrovascular_disease}{Input characters (no, yes) to indicate if the patient
has cerebrovascular disease.
\itemize{
  \item no stands for not having cerebrovascular disease.
  \item yes stands for having cerebrovascular disease.
}}

\item{have_carotid_bruits}{Input characters (no, yes) to indicate if the patient
has carotid bruits.
\itemize{
  \item no stands for not having carotid bruits.
  \item yes stands for having carotid bruits.
}}

\item{max_na}{Input integer 0 to 3 to indicate the maximum number of
missing disease history to tolerate before outputting an \code{NA}.
Default: 0}
}
\value{
An integer indicating the patient's vascular disease index.
It can also be \code{NA} if the number of missing disease history exceeds the \code{max_na}
input value.
}
\description{
A function used to calculate the patient's
vascular disease index. This is used to calculate the likelihood
of severe coronary artery disease in the
Duke Clinical Score 1993 paper.
}
\examples{
calculate_dcs_1993_vascular_disease_index(
  have_peripheral_vascular_disease = "yes",
  have_cerebrovascular_disease = "yes",
  have_carotid_bruits = "no"
)

calculate_dcs_1993_vascular_disease_index(
  have_peripheral_vascular_disease = NA,
  have_cerebrovascular_disease = "yes",
  have_carotid_bruits = "no",
  max_na = 0
)

calculate_dcs_1993_vascular_disease_index(
  have_peripheral_vascular_disease = NA,
  have_cerebrovascular_disease = "yes",
  have_carotid_bruits = "no",
  max_na = 1
)
}
