% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dcs_ptp.R
\name{calculate_dcs_1993_pain_index}
\alias{calculate_dcs_1993_pain_index}
\title{Calculate The Pain Index For Duke Clinical Score 1993}
\usage{
calculate_dcs_1993_pain_index(
  have_typical_chest_pain,
  frequency_of_angina_pain_per_week,
  have_progressive_angina,
  have_nocturnal_angina,
  have_q_waves,
  have_st_t_changes,
  max_na = 0,
  max_frequency_of_angina_pain_per_week = 35
)
}
\arguments{
\item{have_typical_chest_pain}{Input characters (no, yes) to indicate if the patient
has typical chest pain.
\itemize{
  \item no stands for not having typical chest pain.
  \item yes stands for having typical chest pain.
}}

\item{frequency_of_angina_pain_per_week}{Input integer to indicate the patient's
frequency of angina per week.}

\item{have_progressive_angina}{Input characters (no, yes) to indicate if the patient
has progressive angina.
\itemize{
  \item no stands for not having progressive angina.
  \item yes stands for having progressive angina.
}}

\item{have_nocturnal_angina}{Input characters (no, yes) to indicate if the patient
has nocturnal angina.
\itemize{
  \item no stands for not having nocturnal angina.
  \item yes stands for having nocturnal angina.
}}

\item{have_q_waves}{Input characters (no, yes) to indicate if the patient
has Q waves on electrocardiogram (ECG).
\itemize{
  \item no stands for the patient not having Q waves on ECG.
  \item yes stands for the patient having Q waves on ECG.
}}

\item{have_st_t_changes}{Input characters (no, yes) to indicate if the patient
has ST-T changes on electrocardiogram (ECG).
\itemize{
  \item no stands for the patient not having ST-T changes on ECG.
  \item yes stands for the patient having ST-T changes on ECG.
}}

\item{max_na}{Input integer 0 to 6 to indicate the maximum number of
missing symptoms to tolerate before outputting an \code{NA}.
Default: 0}

\item{max_frequency_of_angina_pain_per_week}{Input non-negative integer to
indicate the maximum frequency angina per week to tolerate before outputting an \code{NA}.
In the Duke Clinical Score 1993 paper, the maximum value is set as 35.
Default: 35}
}
\value{
An integer indicating the patient's pain index.
It can also be \code{NA} if the number of missing symptoms exceeds the \code{max_na}
input value or the frequency of angina per week exceed the
\code{max_frequency_of_angina_pain_per_week} input value.
}
\description{
A function used to calculate the patient's
pain index. This is used to calculate the likelihood
of severe coronary artery disease in the
Duke Clinical Score 1993 paper.
}
\examples{
calculate_dcs_1993_pain_index(
  have_typical_chest_pain = "yes",
  frequency_of_angina_pain_per_week = 10,
  have_progressive_angina = "yes",
  have_nocturnal_angina = "no",
  have_q_waves = "no",
  have_st_t_changes = "no",
  max_na = 0,
  max_frequency_of_angina_pain_per_week = 35
)

calculate_dcs_1993_pain_index(
  have_typical_chest_pain = "yes",
  frequency_of_angina_pain_per_week = 10,
  have_progressive_angina = "yes",
  have_nocturnal_angina = NA,
  have_q_waves = "no",
  have_st_t_changes = "no",
  max_na = 0,
  max_frequency_of_angina_pain_per_week = 35
)

calculate_dcs_1993_pain_index(
  have_typical_chest_pain = "yes",
  frequency_of_angina_pain_per_week = 10,
  have_progressive_angina = "yes",
  have_nocturnal_angina = NA,
  have_q_waves = "no",
  have_st_t_changes = "no",
  max_na = 1,
  max_frequency_of_angina_pain_per_week = 35
)

calculate_dcs_1993_pain_index(
  have_typical_chest_pain = "yes",
  frequency_of_angina_pain_per_week = 40,
  have_progressive_angina = "yes",
  have_nocturnal_angina = "no",
  have_q_waves = "no",
  have_st_t_changes = "no",
  max_na = 0,
  max_frequency_of_angina_pain_per_week = 35
)

calculate_dcs_1993_pain_index(
  have_typical_chest_pain = "yes",
  frequency_of_angina_pain_per_week = 40,
  have_progressive_angina = "yes",
  have_nocturnal_angina = "no",
  have_q_waves = "no",
  have_st_t_changes = "no",
  max_na = 0,
  max_frequency_of_angina_pain_per_week = NA
)

}
