% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confirm_ptp.R
\name{calculate_confirm_2015_num_of_rf}
\alias{calculate_confirm_2015_num_of_rf}
\title{Calculate Number Of Risk Factors (CONFIRM 2015)}
\usage{
calculate_confirm_2015_num_of_rf(
  have_typical_chest_pain,
  have_diabetes,
  have_hypertension,
  have_family_history,
  is_current_smoker,
  max_na = 0
)
}
\arguments{
\item{have_typical_chest_pain}{Input characters (no, yes) to indicate if the patient
has typical chest pain.
\itemize{
  \item no stands for not having typical chest pain.
  \item yes stands for having typical chest pain.
}}

\item{have_diabetes}{Input characters (no, yes) to indicate if the patient
only has diabetes.
\itemize{
  \item no stands for not having diabetes.
  \item yes stands for having diabetes.
}}

\item{have_hypertension}{Input characters (no, yes) to indicate if the patient
only has hypertension.
\itemize{
  \item no stands for not having hypertension.
  \item yes stands for having a hypertension.
}}

\item{have_family_history}{Input characters (no, yes) to indicate if the patient
only has a family history of CAD.
\itemize{
  \item no stands for not having a family history of CAD.
  \item yes stands for having a family history of CAD.
}}

\item{is_current_smoker}{Input characters (no, yes) to indicate if the patient
is a current smoker.
\itemize{
  \item no stands for patient is a current smoker.
  \item yes stands for patient is a not current smoker (past or non-smoker).
}}

\item{max_na}{Input integer 0 to 5 to indicate the maximum number of
missing risk factors to tolerate before outputting an \code{NA}.
Default: 0}
}
\value{
An integer indicating the number of risk factors the patient has.
It can also be \code{NA} if the number of missing risk factors exceeds the \code{max_na}
input value
}
\description{
A function used to calculate the number of
risk factors the patient has. This is used to calculate the pretest
probability of coronary artery disease (CAD) based on the
2015 CONFIRM Risk Score.
}
\examples{
calculate_confirm_2015_num_of_rf(
  have_typical_chest_pain = "yes",
  have_diabetes = "yes",
  have_hypertension = "yes",
  have_family_history = "yes",
  is_current_smoker = "no"
)

calculate_confirm_2015_num_of_rf(
  have_typical_chest_pain = "no",
  have_diabetes = "no",
  have_hypertension = "no",
  have_family_history = NA,
  is_current_smoker = "no",
  max_na = 0
)

calculate_confirm_2015_num_of_rf(
  have_typical_chest_pain = "no",
  have_diabetes = "no",
  have_hypertension = "no",
  have_family_history = NA,
  is_current_smoker = "no",
  max_na = 1
)
}
