% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pressuRe_functions.R
\name{footprint}
\alias{footprint}
\title{Footprint}
\usage{
footprint(pressure_data, variable = "max", frame = NULL, plot = FALSE)
}
\arguments{
\item{pressure_data}{List. Includes a 3D array covering each timepoint of the
measurement. z dimension represents time}

\item{variable}{String. "max" = maximum value of each sensor across full
dataset. "mean" = average value of sensors over full dataset."frame" = an
individual pressure frame. "meanmax" average max values across cycles (
currently just for pedar)}

\item{frame}{Integer. Only used if variable = "frame".}

\item{plot}{Logical. Display pressure image}
}
\value{
Matrix. Maximum or mean values for all sensors
}
\description{
Determines footprint of pressure data
}
\examples{
emed_data <- system.file("extdata", "emed_test.lst", package = "pressuRe")
pressure_data <- load_emed(emed_data)
footprint(pressure_data, plot = FALSE)
}
