% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/due_date.R
\name{due_date-option}
\alias{due_date-option}
\alias{set_due_date}
\alias{get_due_date}
\title{Set or get the \code{pregnancy.due_date} option}
\usage{
set_due_date(due_date)

get_due_date()
}
\arguments{
\item{due_date}{A Date or character string representing a date, e.g. "YYYY-MM-DD",
specifying the estimated due date, or NULL to unset the option.}
}
\value{
Both functions invisibly return the current due date setting:
\itemize{
\item get_due_date() returns the current setting (a Date object) or NULL if not set
\item set_due_date() returns the due date value that was set
}
}
\description{
Functions to get and set the default due date used throughout the package.
This affects calculations in various functions that determine pregnancy progress
and timing. Settings persist for the current R session only, unless added to
.Rprofile. \code{set_due_date()} sets the "pregnancy.due_date" option and \code{get_due_date()} retrieves it.
}
\examples{
# Store original setting (without messages)
original_due_date <- getOption("pregnancy.due_date")

# Check current setting
get_due_date()

# Set due date and check again
set_due_date("2025-09-15")
get_due_date()

# Restore original setting (without messages)
options(pregnancy.due_date = original_due_date)

}
\seealso{
\itemize{
\item \code{\link[=calculate_due_date]{calculate_due_date()}} to calculate a due date based on other dates
\item \code{\link[=how_far]{how_far()}} and other functions that use the due date for calculations
}
}
