% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preferences.R
\name{preferences}
\alias{preferences}
\alias{[.preferences}
\alias{as.preferences}
\alias{as.preferences.grouped_preferences}
\alias{as.preferences.default}
\alias{as.preferences.matrix}
\alias{as.preferences.aggregated_preferences}
\alias{format.preferences}
\title{Preferences Object}
\usage{
preferences(
  data,
  format = c("long", "ordering", "ranking"),
  id = NULL,
  rank = NULL,
  item = NULL,
  item_names = NULL,
  frequencies = NULL,
  aggregate = FALSE,
  verbose = TRUE,
  ...
)

\method{[}{preferences}(x, i, j, ..., by.rank = FALSE, as.ordering = FALSE)

as.preferences(x, ...)

\method{as.preferences}{grouped_preferences}(x, aggregate = FALSE, verbose = TRUE, ...)

\method{as.preferences}{default}(
  x,
  format = c("long", "ranking", "ordering"),
  id = NULL,
  item = NULL,
  rank = NULL,
  item_names = NULL,
  aggregate = FALSE,
  verbose = TRUE,
  ...
)

\method{as.preferences}{matrix}(
  x,
  format = c("long", "ranking"),
  id = NULL,
  item = NULL,
  rank = NULL,
  item_names = NULL,
  aggregate = FALSE,
  verbose = TRUE,
  ...
)

\method{as.preferences}{aggregated_preferences}(x, ...)

\method{format}{preferences}(x, width = 40L, ...)
}
\arguments{
\item{data}{A data frame or matrix in one of three formats:
\describe{
\item{"ordering"}{Orderings must be a data frame with list-valued
columns. Each row represents an ordering of the items
from first to last, representing ties by a list of
vectors corresponding to the items.}
\item{"ranking"}{Each row assigns a rank to each item, with columns
representing items.  Note that rankings will be converted
to 'dense' rankings in the output (see Details).}
\item{"long"}{Three columns: an \code{id} column grouping the rows which
correspond to a single set of preferences, an
\code{item} column specifying (either by index or by
name) the item each row refers to, and a \code{rank}
column specifying the rank for the associated
item.}
}}

\item{format}{The format of the data: one of "ordering", "ranking", or
"long" (see above). By default, \code{data} is assumed to be in "long" format.}

\item{id}{For \code{data} in long-format: the column representing the
preference set grouping.}

\item{rank}{For \code{data} in long-format: the column representing the
rank for the associated item.}

\item{item}{For \code{data} in long-format: the column representing
the items by name or by index, in which case the
\code{item_names} parameter should also be passed, or the items will be named as
integers.}

\item{item_names}{The names of the full set of items. When loading data using
integer-valued indices in place of item names, the \code{item_names} character
vector should be in the correct order.}

\item{frequencies}{An optional integer vector containing the number of
occurences of each preference. If provided, the method will return a
\code{\link[=aggregate.preferences]{aggregated_preferences}} object with the
corresponding frequencies.}

\item{aggregate}{If \code{TRUE}, aggregate the preferences via
\code{\link{aggregate.preferences}} before returning. This
returns an \code{\link[=aggregate.preferences]{aggregated_preferences}} object.}

\item{verbose}{If \code{TRUE}, diagnostic messages will be sent to stdout.}

\item{...}{Unused.}

\item{x}{The \code{preferences} object to subset.}

\item{i}{The index of the preference-set to access.}

\item{j}{The item names or indices to project onto, e.g. if \code{j = 1} the
preferences will be projected only onto the first item; if \code{by.rank = TRUE}
\code{j} corresponds to the rank of the items to subset to, e.g. if \code{j = 1} then
preferences will be truncated to only contain their highest-preference.}

\item{by.rank}{When \code{FALSE}, the index \code{j} corresponds to items, when true
the index corresponds to rank.}

\item{as.ordering}{When \code{FALSE}, returns a \code{preferences} object:
internally rows \eqn{i} contain the ranking assigned to each item
in preference \eqn{p_i}. When \code{TRUE}, returns a data frame where
columns group the items by rank.}

\item{width}{The width in number of characters to format each preference,
truncating by "..." when they are too long.}
}
\value{
By default, a \code{preferences} object, which is a data frame with
list-valued columns corresponding to preferences on the items. This may
be an ordering on subsets of the items in the case of ties, or a
potentially-partial strict ordering. In the case of partial or tied
preferences, some entries may be empty lists.
}
\description{
Create a \code{preferences} object for representing Ordinal Preference datasets.
}
\details{
Ordinal preferences can order every item, or they can order a subset. Some
ordinal preference datasets will contain ties between items at a given rank.
Hence, there are four distinct types of preferential data:
\describe{
\item{\code{soc}}{Strict Orders - Complete List}
\item{\code{soi}}{Strict Orders - Incomplete List}
\item{\code{toc}}{Orders with Ties - Complete List}
\item{\code{toi}}{Orders with Ties - Incomplete List}
}
The data type is stored alongside the \code{preferences} as an attribute
\code{attr(preferences, "preftype")}. The data type is determined automatically.
If every preference ranks every item, then the data type will be
"soc" or "soi". Similarly, if no preference contains a tie the data type
will be "toc" or "toi".

A set of preferences can be represented either by \code{ranking} or by
\code{ordering}. These correspond to the two ways you can list a set of
preferences in a vector:
\describe{
\item{\code{ordering}}{The items are listed in order of most preferred to least
preferred, allowing for multiple items being in the
same place in the case of ties.}
\item{\code{ranking}}{A rank is assigned to each item.  Conventionally, ranks are
integers in increasing order (with larger values
indicating lower preference), but they can be any
ordinal values.  Any given rankings will be converted
to 'dense' rankings: positive integers from 1 to some
maximum rank, with no gaps between ranks.}
}
When reading preferences from an \code{ordering} matrix, the index on the
items is the order passed to the \code{item_names} parameter. When reading from
a \code{rankings} matrix, if no \code{item_names} are provided, the order is inferred
from the named columns.

A \code{preferences} object can also be read from a long-format matrix, where
there are three columns: \code{id}, \code{item} and \code{rank}. The \code{id} variable groups
the rows of the matrix which correspond to a single set of preferences, which
the \code{item:rank}, pairs indicate how each item is ranked. When reading a
matrix from this format and no \code{item_names} parameter is passed, the order is
determined automatically.
}
\examples{
# create rankings from data in long form

# Example long-form data
x <- data.frame(
  id = c(rep(1:4, each = 4), 5, 5, 5),
  item = c(
    LETTERS[c(1:3, 3, 1:4, 2:5, 1:2, 1)], NA,
    LETTERS[3:5]
  ),
  rank = c(4:1, rep(NA, 4), 3:4, NA, NA, 1, 3, 4, 2, 2, 2, 3)
)

# * Set #1 has two different ranks for the same item (item C
# has rank 1 and 2). This item will be excluded from the preferences.
# * All ranks are missing in set #2, a technically valid partial ordering
# * Some ranks are missing in set #3, a perfectly valid partial ordering
# * Set #4 has inconsistent ranks for two items, and a rank with a
# missing item.
# * Set #5 is not a dense ranking. It will be converted to be dense and then
# inferred to be a regular partial ordering with ties.
split(x, x$rank)

# Creating a preferences object with this data will attempt to resolve these
# issues automatically, sending warnings when assumptions need to be made.
preferences(x, id = "id", item = "item", rank = "rank")

# Convert an existing matrix of rankings to a preferences object.
rnk <- matrix(c(
  1, 2, 0, 0,
  4, 1, 2, 3,
  2, 1, 1, 1,
  1, 2, 3, 0,
  2, 1, 1, 0,
  1, 0, 3, 2
), nrow = 6, byrow = TRUE)
colnames(rnk) <- c("apple", "banana", "orange", "pear")

rnk <- as.preferences(rnk, format = "ranking")

# Convert an existing data frame of orderings to a preferences object.
e <- character() # short-hand for empty ranks
ord <- preferences(
  as.data.frame(
    rbind(
      list(1, 2, e, e), # apple, banana
      list("banana", "orange", "pear", "apple"),
      list(c("banana", "orange", "pear"), "apple", e, e),
      list("apple", "banana", "orange", e),
      list(c("banana", "orange"), "apple", e, e),
      list("apple", "pear", "orange", e)
    )
  ),
  format = "ordering",
  item_names = c("apple", "banana", "orange", "pear")
)

# Access the first three sets of preferences
ord[1:3, ]

# Truncate preferences to the top 2 ranks
ord[, 1:2, by_rank = TRUE]

# Exclude pear from the rankings
ord[, -4]

# Get the highest-ranked items and return as a data.frame of orderings
ord[, 1, by_rank = TRUE, as.ordering = TRUE]

# Convert the preferences to a ranking matrix
as.matrix(ord)

# Get the rank of apple in the third preference-set
as.matrix(ord)[3, 1]

# Get all the ranks assigned to apple as a vector
as.matrix(ord)[, "apple"]

}
