% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preference.r
\docType{data}
\name{imap_strat}
\alias{imap_strat}
\title{Stratified summary data for the IMAP study}
\description{
Data set is from the Improving Management of Abnormal Pap Smears
study, which used a two-stage randomized preference trial design to evaluate 
psychosocial outcomes in women found to have atypical cells in a Pap Smear. 
Two systems for managing the atypical cells were tested (repeated Pap smears
or HCV triage) and a doubly randomized design was used to evaluate the role 
of patient preference. 

In this data set, patients are stratified according to their baseline score
on the six-item abbreviated Spielberger State-Trait Anxiety Inventory (STAI).
This assessment is used to assess the level of anxiety experienced by 
patients. Stratum 1 includes patients with low STAI scores (<=10 on STAI 
averaged across whole study), which indicates low levels of anxiety. 
Stratum 2 includes patients with high STAI  scores (>10), indicating higher
levels of anxiety. The data set provides mean, standard deviation and 
sample sizes of the SF36 outcome for each treatment in both the choice and 
random arms for both strata.
}
\references{
McCaffery et al. (2010) "Psychosocial outcomes of three triage 
methods for the management of borderline abnormal cervical smears: an open 
randomised trial." \emph{BMJ}, \strong{340}:b4491.
(\href{https://www.ncbi.nlm.nih.gov/pmc/articles/PMC2827716/}{PubMed})

McCaffery et al. (2011) "Determining the Impact of Informed 
Choice: Separating Treatment Effects from the Effects of Choice and Selection
in Randomized Trials." \emph{Med Decis Making}, \strong{31}(2):229-236.
(\href{https://www.ncbi.nlm.nih.gov/pubmed/21041538}{PubMed})

Marteau TM, Bekker H. (1992) "The development of a six-item 
short-form of the state scale of the Spielberger State-Trait Anxiety 
Inventory (STAI)." \emph{Br J Clin Psychol}, \strong{31}:301-306.
(\href{https://www.ncbi.nlm.nih.gov/pubmed/1393159#}{PubMed})
}
\keyword{data}
