% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lmer_bs.R
\name{lmer_bs}
\alias{lmer_bs}
\title{Sampling of bootstrap data from a given random effects model}
\usage{
lmer_bs(model, newdat = NULL, futmat_list = NULL, nboot)
}
\arguments{
\item{model}{a random effects model of class lmerMod}

\item{newdat}{a \code{data.frame} with the same column names as the historical data
on which \code{model} depends}

\item{futmat_list}{a list that contains design matrices for each random factor}

\item{nboot}{number of bootstrap samples}
}
\value{
A list of length \code{nboot} containing the bootstrapped observations.
}
\description{
\code{lmer_bs()} draws bootstrap samples based on the estimates for the mean
and the variance components drawn from a random effects model fit with \code{lme4::lmer()}.
Contrary to \code{lme4::bootMer()}, the number of observations for each random factor
can vary between the original data set and the bootstrapped data. Random effects
in \code{model} have to be specified as \code{(1|random effect)}.
}
\details{
The data sampling is based on a list of design matrices (one for each random factor)
that can be obtained if \code{newdat} and the model formula are provided to
\code{lme4::lFormula()}. Hence, each random factor that is part of the initial
model must have at least two replicates in \code{newdat}. \cr
If a random factor in the future data set does not have any replicate, a list
that contains design matrices (one for each random factor) can be provided via
\code{futmat_list}.
}
\examples{

# loading lme4
library(lme4)

# Fitting a random effects model based on c2_dat1

fit <- lmer(y_ijk~(1|a)+(1|b)+(1|a:b), c2_dat1)
\donttest{summary(fit)}

#----------------------------------------------------------------------------

### Using c2_dat2 as newdat

c2_dat2

lmer_bs(model=fit, newdat=c2_dat2, nboot=100)

#----------------------------------------------------------------------------

### Using futmat_list

# c2_dat4 has no replication for b. Hence the list of design matrices can not be
# generated by lme4::lFormula() and have to be provided by hand via futmat_list.

c2_dat4

# Build a list containing the design matrices

fml <- vector(length=4, "list")

names(fml) <- c("a:b", "b", "a", "Residual")

fml[["a:b"]] <- matrix(nrow=6, ncol=2, data=c(1,1,0,0,0,0, 0,0,1,1,1,1))

fml[["b"]] <- matrix(nrow=6, ncol=1, data=c(1,1,1,1,1,1))

fml[["a"]] <- matrix(nrow=6, ncol=2, data=c(1,1,0,0,0,0, 0,0,1,1,1,1))

fml[["Residual"]] <- diag(6)

fml

lmer_bs(model=fit, futmat_list=fml, nboot=100)

}
