% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predhy.predict_NCII.R
\name{predhy.predict_NCII}
\alias{predhy.predict_NCII}
\title{Predict the Performance of Hybrids}
\usage{
predhy.predict_NCII(
  inbred_gen,
  hybrid_phe,
  inbred_phe = NULL,
  male_name = hybrid_phe[, 1],
  female_name = hybrid_phe[, 2],
  method = "GBLUP",
  model = "A",
  select = "top",
  number = "100"
)
}
\arguments{
\item{inbred_gen}{a matrix for genotypes of parental lines in numeric format, coded as 1, 0 and -1. The row.names of inbred_gen must be provied. It can be obtained from the original genotype using  \code{\link{convertgen}} function.}

\item{hybrid_phe}{a data frame with three columns. The first column and the second column are the names of male and female parents of the corresponding hybrids, respectively; the third column is the phenotypic values of hybrids.
The names of male and female parents must match the rownames of inbred_gen. Missing (NA) values are not allowed.}

\item{inbred_phe}{a matrix (n x 2) of inbred_phe phenotypic.Default is NULL.}

\item{male_name}{a vector of the names of male parents.}

\item{female_name}{a vector of the names of female parents.}

\item{method}{eight GS methods including "GBLUP", "BayesB", "RKHS", "PLS", "LASSO", "EN", "XGBoost", "LightGBM".
Users may select P of these methods. Default is "GBLUP".}

\item{model}{the prediction model. There are two options: model = "A" for the additive model, model = "AD" for the additive-dominance model,model = "A-P" for the additive-phenotypic model,model = "AD-P" for the additive-dominance-phenotypic model. Default is model = "A".}

\item{select}{the selection of hybrids based on the prediction results. There are three options: select = "all", which selects all potential crosses. select = "top", which selects the top n crosses. select = "bottom", which selects the bottom n crosses. The n is determined by the param number.}

\item{number}{the number of selected top or bottom hybrids, only when select = "top" or select = "bottom".}
}
\value{
a data frame of prediction results with two columns. The first column denotes the names of male and female parents of the predicted hybrids, and the second column denotes the phenotypic values of the predicted hybrids.
}
\description{
Predict all potential crosses of a given set of parents using a subset of crosses as the training sample.
}
\examples{
\donttest{
## load example data from hypred package
data(hybrid_phe)
data(input_geno)
inbred_gen <- convertgen(input_geno, type = "hmp2")

## infer the additive and dominance genotypes of hybrids
gena <- infergen(inbred_gen, hybrid_phe)$add
gend <- infergen(inbred_gen, hybrid_phe)$dom

pred<-predhy.predict_NCII(inbred_gen,hybrid_phe,method="LASSO",model="A")
pred<-predhy.predict_NCII(inbred_gen,hybrid_phe,method="LASSO",model = "AD",select="all")
 }
}
