% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mm1_create_mmdat.R
\name{mmdata}
\alias{mmdata}
\title{Reformat input data for performance evaluation calculation}
\usage{
mmdata(
  scores,
  labels,
  modnames = NULL,
  dsids = NULL,
  posclass = NULL,
  na_worst = TRUE,
  ties_method = "equiv",
  expd_first = NULL,
  mode = "rocprc",
  nfold_df = NULL,
  score_cols = NULL,
  lab_col = NULL,
  fold_col = NULL,
  ...
)
}
\arguments{
\item{scores}{A numeric dataset of predicted scores. It can be a vector,
a matrix, an array, a data frame, or a list. The \code{\link{join_scores}}
function can be useful to make scores with multiple datasets.}

\item{labels}{A numeric, character, logical, or factor dataset
of observed labels. It can be a vector, a matrix, an array,
a data frame, or a list. The \code{\link{join_labels}}
function can be useful to make labels with multiple datasets.}

\item{modnames}{A character vector for the names of the models.
The \code{evalmod} function automatically generates default names
as "m1", "m2", "m3", and so on when it is \code{NULL}.}

\item{dsids}{A numeric vector for test dataset IDs.
The \code{evalmod} function automatically generates the default ID
as \code{1} when it is \code{NULL}.}

\item{posclass}{A scalar value to specify the label of positives
in \code{labels}. It must be the same data type as \code{labels}.
For example, \code{posclass = -1} changes the positive label
from \code{1} to \code{-1} when \code{labels} contains
\code{1} and \code{-1}. The positive label will be automatically
detected when \code{posclass} is \code{NULL}.}

\item{na_worst}{A Boolean value for controlling the treatment of NAs
in \code{scores}.
\describe{
  \item{TRUE}{All NAs are treated as the worst scores}
  \item{FALSE}{All NAs are treated as the best scores}
}}

\item{ties_method}{A string for controlling ties in \code{scores}.
\describe{
  \item{"equiv"}{Ties are equivalently ranked}
  \item{"first"}{Ties are ranked in an increasing order as appeared}
  \item{"random"}{ Ties are ranked in random order}
}}

\item{expd_first}{A string to indicate which of the two variables
  - model names or test dataset IDs
  should be expanded first when they are automatically generated.

  \describe{
    \item{"modnames"}{Model names are expanded first. For example,
           The \code{mmdata} function generates \code{modnames} as
           \code{c("m1", "m2")} and \code{dsids} as \code{c(1, 1)}
           when two vectors are passed as input,
           and \code{modnames} and \code{dsids} are unspecified.}
    \item{"dsids"}{Test dataset IDs are expanded first. For example,
           The \code{mmdata} function generates \code{modnames} as
           \code{c("m1", "m1")} and \code{dsids} as \code{c(1, 2)}
           when two vectors are passed as input,
           and \code{modnames} and \code{dsids} are unspecified.}
  }}

\item{mode}{A string that specifies the types of evaluation measures
that the \code{evalmod} function calculates.
\describe{
  \item{"rocprc"}{ROC and Precision-Recall curves}
  \item{"prcroc"}{Same as above}
  \item{"basic"}{Normalized ranks vs. accuracy, error rate, specificity,
                 sensitivity, precision, Matthews correlation coefficient,
                 and F-score. }
  \item{"aucroc"}{Fast AUC(ROC) calculation with the U statistic}
}}

\item{nfold_df}{A data frame that contains at least one score column,
label and fold columns.}

\item{score_cols}{A character/numeric vector that specifies score columns
of \code{nfold_df}.}

\item{lab_col}{A number/string that specifies the label column
of \code{nfold_df}.}

\item{fold_col}{A number/string that specifies the fold column
of \code{nfold_df}.}

\item{...}{Not used by this method.}
}
\value{
The \code{mmdata} function returns an \code{mdat} object
  that contains formatted labels and score ranks. The object can
  be used as input data for the \code{\link{evalmod}} function.
}
\description{
The \code{mmdata} function takes predicted scores and labels
  and returns an \code{mdat} object. The \code{\link{evalmod}} function
  takes an \code{mdat} object as input data to calculate evaluation measures.
}
\examples{

##################################################
### Single model & single test dataset
###

## Load a dataset with 10 positives and 10 negatives
data(P10N10)

## Generate mdat object
ssmdat1 <- mmdata(P10N10$scores, P10N10$labels)
ssmdat1
ssmdat2 <- mmdata(1:8, sample(c(0, 1), 8, replace = TRUE))
ssmdat2


##################################################
### Multiple models & single test dataset
###

## Create sample datasets with 100 positives and 100 negatives
samps <- create_sim_samples(1, 100, 100, "all")

## Multiple models & single test dataset
msmdat1 <- mmdata(samps[["scores"]], samps[["labels"]],
                  modnames = samps[["modnames"]])
msmdat1

## Use join_scores and join_labels
s1 <- c(1, 2, 3, 4)
s2 <- c(5, 6, 7, 8)
scores <- join_scores(s1, s2)

l1 <- c(1, 0, 1, 1)
l2 <- c(1, 0, 1, 1)
labels <- join_labels(l1, l2)

msmdat2 <- mmdata(scores, labels, modnames = c("ms1", "ms2"))
msmdat2


##################################################
### Single model & multiple test datasets
###

## Create sample datasets with 100 positives and 100 negatives
samps <- create_sim_samples(10, 100, 100, "good_er")

## Single model & multiple test datasets
smmdat <- mmdata(samps[["scores"]], samps[["labels"]],
                 modnames = samps[["modnames"]],
                 dsids = samps[["dsids"]])
smmdat


##################################################
### Multiple models & multiple test datasets
###

## Create sample datasets with 100 positives and 100 negatives
samps <- create_sim_samples(10, 100, 100, "all")

## Multiple models & multiple test datasets
mmmdat <- mmdata(samps[["scores"]], samps[["labels"]],
                 modnames = samps[["modnames"]],
                 dsids = samps[["dsids"]])
mmmdat


##################################################
### N-fold cross validation datasets
###

## Load test data
data(M2N50F5)
head(M2N50F5)

## Speficy nessesary columns to create mdat
cvdat1 <- mmdata(nfold_df = M2N50F5, score_cols = c(1, 2),
                 lab_col = 3, fold_col = 4,
                 modnames = c("m1", "m2"), dsids = 1:5)
cvdat1

## Use column names
cvdat2 <- mmdata(nfold_df = M2N50F5, score_cols = c("score1", "score2"),
                 lab_col = "label", fold_col = "fold",
                 modnames = c("m1", "m2"), dsids = 1:5)
cvdat2

}
\seealso{
\code{\link{evalmod}} for calculation evaluation measures.
  \code{\link{join_scores}} and \code{\link{join_labels}} for formatting
  scores and labels with multiple datasets.
  \code{\link{format_nfold}} for creating n-fold cross validation dataset
  from data frame.
}
