% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setup.R
\name{use_ci}
\alias{use_ci}
\title{Use continuous integration with pre-commit}
\usage{
use_ci(
  ci = getOption("precommit.ci", "native"),
  force = FALSE,
  open = rstudioapi::isAvailable(),
  root = here::here()
)
}
\arguments{
\item{ci}{Specifies which continuous integration service to use. See
\code{vignette("ci", package = "precommit")} for details. Defaults to
\code{getOption("precommit.ci", "native")}, which is set to
\code{"native"} on package loading (if unset). \code{"native"} sets up
\href{https://pre-commit.ci}{pre-commit.ci}. Alternatively, \code{"gha"} can be used
to set up \href{https://github.com/features/actions}{GitHub Actions}. Set value
to \code{NULL} if you don't want to use a continuous integration.}

\item{force}{Whether or not to overwrite an existing ci config file (only
relevant for \code{ci = "gha"}).}

\item{open}{Whether or not to open \href{https://pre-commit.ci}{pre-commit.ci}
(if \code{ci = "native"}). The default is \code{TRUE} when working in RStudio.}

\item{root}{The path to the root directory of your project.}
}
\description{
Sets up continuous integration, or prompts the user to do it manually.
}
