% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ATE_continuous.R
\name{atefitmean}
\alias{atefitmean}
\title{Doubly robust estimator of and inference for the average treatment effect for
continuous data}
\usage{
atefitmean(
  data,
  cate.model,
  ps.model,
  ps.method = "glm",
  minPS = 0.01,
  maxPS = 0.99,
  interactions = TRUE,
  n.boot = 500,
  plot.boot = FALSE,
  seed = NULL,
  verbose = 0
)
}
\arguments{
\item{data}{A data frame containing the variables in the outcome and
propensity score models; a data frame with \code{n} rows (1 row per
observation).}

\item{cate.model}{A formula describing the outcome model to be fitted.
The outcome must appear on the left-hand side.}

\item{ps.model}{A formula describing the propensity score model to be fitted.
The treatment must appear on the left-hand side. The treatment must be a
numeric vector coded as 0/1. If data are from a RCT, specify \code{ps.model}
as an intercept-only model.}

\item{ps.method}{A character value for the method to estimate the propensity
score. Allowed values include one of: \code{'glm'} for logistic regression
with main effects only (default), or \code{'lasso'} for a logistic regression
with main effects and LASSO penalization on two-way interactions (added to
the model if interactions are not specified in \code{ps.model}). Relevant
only when \code{ps.model} has more than one variable.}

\item{minPS}{A numerical value between 0 and 1 below which estimated
propensity scores should be truncated. Default is \code{0.01}.}

\item{maxPS}{A numerical value between 0 and 1 above which estimated
propensity scores should be truncated. Must be strictly greater than
\code{minPS}. Default is \code{0.99}.}

\item{interactions}{A logical value indicating whether the outcome model
should be fitted separately by treatment arm with the variables in
\code{cate.model}, which is equivalent to assuming treatment-covariate
interaction by all of the variables in \code{cate.model}. If \code{TRUE}, the
outcome model will be fitted separately by treatment arms only if at least
10 patients received each treatment option. Default is \code{TRUE}.}

\item{n.boot}{A numeric value indicating the number of bootstrap samples
used. Default is \code{500}.}

\item{plot.boot}{A logical value indicating whether histograms of the
bootstrapped treatment effect estimates should be produced at every
\code{n.boot/10}-th iteration and whether the final histogram should be
outputted. Default is \code{FALSE}.}

\item{seed}{An optional integer specifying an initial randomization seed for
reproducibility. Default is \code{NULL}, corresponding to no seed.}

\item{verbose}{An integer value indicating whether intermediate progress
messages and histograms should be printed. \code{1} indicates messages are
printed and \code{0} otherwise. Default is \code{0}.}
}
\value{
Return a list of 8 elements:
\itemize{
  \item{\code{log.rate.ratio}: } A numeric value of the estimated log rate ratio.
  \item{\code{se.boot.log.rate.ratio}: } A numeric value of the bootstrap standard error of log rate ratio.
  \item{\code{rate.ratio}: } A numeric value of the estimated rate ratio.
  \item{\code{rate.ratio0}: } A numeric value of the estimated rate in the group trt=0.
  \item{\code{rate.ratio1}: } A numeric value of the estimated rate in the group trt=1.
  \item{\code{rate.ratio.CIl}: } A numeric value of the lower limit 95\% bootstrap confidence interval
    for estimated rate ratio.
  \item{\code{rate.ratio.CIu}: } A numeric value of the upper limit 95\% bootstrap confidence interval
    for estimated rate ratio.
  \item{\code{pvalue}: } A numeric value of the p-value derived from the bootstrapped values
    based on a Chi-squared distribution.
  \item{\code{warning}: } A warning message produced if the treatment variable was not coded as 0/1. The key
  to map the original coding of the variable to a 0/1 key is displayed in the warning to facilitate the
  interpretation of the remaining of the output.
  \item{\code{plot}: } If \code{plot.boot} is \code{TRUE}, a histogram displaying the distribution of the bootstrapped log rate ratios.
  The red vertical reference line in the histogram represents the estimated log rate ratio.
}
}
\description{
Doubly robust estimator of the average treatment effect between two
treatments, which is the rate ratio of treatment 1 over treatment 0 for
count outcomes. Bootstrap is used for inference.
}
\details{
This helper function estimates the average treatment effect (ATE) between two
 treatment groups in a given dataset specified by \code{y, trt, x.cate, x.ps, time}. The ATE is
 estimated with a doubly robust estimator that accounts for imbalances in covariate distributions
 between the two treatment groups with inverse probability treatment weighting.
 For count outcomes, the estimated ATE is the estimated
 rate ratio between treatment 1 versus treatment 0. Both original and log-transformed ATEs are
 returned, as well as the rate in either treatment group.
 If \code{inference = TRUE}, the variability of the estimated rate ratio is also calculated
 using bootstrap. Additional variability outputs include standard error of the log rate ratio,
 95\% confidence interval of the rate ratio, p-value, and a histogram of the log rate ratio.
}
\examples{
# This module is not implemented yet!

}
