% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/toxicity_generators.R
\name{plot,mtdi_distribution-method}
\alias{plot,mtdi_distribution-method}
\title{Visualize an \code{mtdi_distribution} object}
\usage{
\S4method{plot}{mtdi_distribution}(x, y = NULL, ...)
}
\arguments{
\item{x}{An \code{mtdi_distribution} object}

\item{y}{Included for compatibility with generic signature}

\item{\dots}{Additional arguments passed onward to \code{plot}}
}
\description{
Visualize an \code{mtdi_distribution} object
}
\examples{
if (interactive()) {
mtdi_dist <- mtdi_lognormal(CV = 2
                           ,median = 5
                           ,units = "mg/kg")
# Setting pre-specified dose levels via options() causes
# toxicity probabilities to be annotated on the plot.
old <- options(dose_levels = c(0.5, 1, 2, 4, 6))
plot(mtdi_dist, col = "red")
options(old)
}
}
