% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tool_zzz.R
\docType{class}
\name{ToolIFBase}
\alias{ToolIFBase}
\title{ToolIFBase}
\format{
An \code{R6} class object
}
\description{
Base class of performance evaluation tools.
}
\details{
\code{ToolIFBase} is an abstract class to provide a uniform interface for
performance evaluation tools.
}
\seealso{
\code{\link{ToolROCR}}, \code{\link{ToolAUCCalculator}},
  \code{\link{ToolPerfMeas}}, \code{\link{ToolPRROC}},
  and \code{\link{Toolprecrec}} are derived from this class.
  \code{\link{create_toolset}} for creating a list of tools.
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ToolIFBase-new}{\code{ToolIFBase$new()}}
\item \href{#method-ToolIFBase-call}{\code{ToolIFBase$call()}}
\item \href{#method-ToolIFBase-get_toolname}{\code{ToolIFBase$get_toolname()}}
\item \href{#method-ToolIFBase-set_toolname}{\code{ToolIFBase$set_toolname()}}
\item \href{#method-ToolIFBase-get_setname}{\code{ToolIFBase$get_setname()}}
\item \href{#method-ToolIFBase-set_setname}{\code{ToolIFBase$set_setname()}}
\item \href{#method-ToolIFBase-get_result}{\code{ToolIFBase$get_result()}}
\item \href{#method-ToolIFBase-get_x}{\code{ToolIFBase$get_x()}}
\item \href{#method-ToolIFBase-get_y}{\code{ToolIFBase$get_y()}}
\item \href{#method-ToolIFBase-get_auc}{\code{ToolIFBase$get_auc()}}
\item \href{#method-ToolIFBase-print}{\code{ToolIFBase$print()}}
\item \href{#method-ToolIFBase-clone}{\code{ToolIFBase$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ToolIFBase-new"></a>}}
\if{latex}{\out{\hypertarget{method-ToolIFBase-new}{}}}
\subsection{Method \code{new()}}{
Default class initialization method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ToolIFBase$new(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{set value for \code{setname}, \code{calc_auc}, \code{store_res},
\code{x}, \code{y}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ToolIFBase-call"></a>}}
\if{latex}{\out{\hypertarget{method-ToolIFBase-call}{}}}
\subsection{Method \code{call()}}{
It calls the tool to calculate precision-recall curves.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ToolIFBase$call(testset, calc_auc, store_res)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{testset}}{\code{R6} object generated by the \code{create_testset} function.}

\item{\code{calc_auc}}{A Boolean value to specify whether the AUC score should be calculated.}

\item{\code{store_res}}{A Boolean value to specify whether the calculated curve is retrieved and stored.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ToolIFBase-get_toolname"></a>}}
\if{latex}{\out{\hypertarget{method-ToolIFBase-get_toolname}{}}}
\subsection{Method \code{get_toolname()}}{
Get the name of the tool.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ToolIFBase$get_toolname()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ToolIFBase-set_toolname"></a>}}
\if{latex}{\out{\hypertarget{method-ToolIFBase-set_toolname}{}}}
\subsection{Method \code{set_toolname()}}{
Set the name of the tool.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ToolIFBase$set_toolname(toolname)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{toolname}}{Name of the tool.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ToolIFBase-get_setname"></a>}}
\if{latex}{\out{\hypertarget{method-ToolIFBase-get_setname}{}}}
\subsection{Method \code{get_setname()}}{
Get the name of the tool set.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ToolIFBase$get_setname()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ToolIFBase-set_setname"></a>}}
\if{latex}{\out{\hypertarget{method-ToolIFBase-set_setname}{}}}
\subsection{Method \code{set_setname()}}{
Set the name of the tool set.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ToolIFBase$set_setname(setname)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{setname}}{Name of the tool set.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ToolIFBase-get_result"></a>}}
\if{latex}{\out{\hypertarget{method-ToolIFBase-get_result}{}}}
\subsection{Method \code{get_result()}}{
Get a list with curve values and the AUC score.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ToolIFBase$get_result()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ToolIFBase-get_x"></a>}}
\if{latex}{\out{\hypertarget{method-ToolIFBase-get_x}{}}}
\subsection{Method \code{get_x()}}{
Get calculated recall values.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ToolIFBase$get_x()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ToolIFBase-get_y"></a>}}
\if{latex}{\out{\hypertarget{method-ToolIFBase-get_y}{}}}
\subsection{Method \code{get_y()}}{
Get calculated precision values.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ToolIFBase$get_y()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ToolIFBase-get_auc"></a>}}
\if{latex}{\out{\hypertarget{method-ToolIFBase-get_auc}{}}}
\subsection{Method \code{get_auc()}}{
Get tne AUC score.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ToolIFBase$get_auc()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ToolIFBase-print"></a>}}
\if{latex}{\out{\hypertarget{method-ToolIFBase-print}{}}}
\subsection{Method \code{print()}}{
Pretty print of the tool interface
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ToolIFBase$print(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Not used.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ToolIFBase-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ToolIFBase-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ToolIFBase$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
