% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PWD_inference.r
\name{PWD_inference}
\alias{PWD_inference}
\title{Weighted Deming Regression -- Inference}
\usage{
PWD_inference(X, Y, lambda=1, MDL=NA, epsilon=1e-8, printem=FALSE)
}
\arguments{
\item{X}{the vector of predicate readings,}

\item{Y}{the vector of test readings,}

\item{lambda}{\emph{optional} (default of 1) - the ratio of the X to the Y precision profile.}

\item{MDL}{\emph{optional} (default to missing) - medical decision level(s),}

\item{epsilon}{\emph{optional} (default of 1.e-8) - convergence tolerance limit,}

\item{printem}{\emph{optional} - if TRUE, routine will print out results as a \code{message}.}
}
\value{
A list containing the following components:

\item{alpha }{the fitted intercept}
\item{beta }{the fitted slope}
\item{cor }{the Pearson correlation between X and Y}
\item{fity }{the vector of predicted Y}
\item{mu }{the vector of estimated latent true values}
\item{resi }{the vector of residuals}
\item{preresi }{the vector of leave-one-out predicted residuals}
\item{sigma }{the estimate of the Rocke-Lorenzato \eqn{\sigma}}
\item{kappa }{the estimate of the Rocke-Lorenzato \eqn{\kappa}}
\item{like }{the -2 log likelihood L}
\item{sealpha }{the jackknife standard error of alpha}
\item{sebeta }{the jackknife standard error of beta}
\item{covar }{the jackknife covariance between alpha and beta}
\item{preMDL }{the predictions at the MDL(s)}
\item{preMDLl }{the lower confidence limit(s) of preMDL}
\item{preMDLu }{the upper confidence limit(s) of preMDL}
}
\description{
This routine fits the regression, uses the jackknife to get its precision,
and optionally prints it out.  Currently implements Rocke-Lorenzato as
the variance profile model.
}
\details{
For the linear model relating the predicate and test readings,
the standard errors of the estimators \eqn{\hat{\alpha}},
\eqn{\hat{\beta}},  and their covariance are estimated by
the jackknife.  The estimates of the intercept and slope are output,
along with their standard errors and covariance.

These estimates are further used
to estimate the predictions at the input \code{MDL}.
}
\examples{
# library
library(ppwdeming)

# parameter specifications
sigma <- 1
kappa <- 0.08
alpha <- 1
beta  <- 1.1
true  <- 8*10^((0:99)/99)
truey <- alpha+beta*true
# simulate single sample - set seed for reproducibility
set.seed(1039)
# specifications for predicate method
X     <- sigma*rnorm(100)+true *(1+kappa*rnorm(100))
# specifications for test method
Y     <- sigma*rnorm(100)+truey*(1+kappa*rnorm(100))

# fit with RL precision profile to estimate parameters and variability
\donttest{RL_inf <- PWD_inference(X,Y,MDL=12,printem=TRUE)}

}
\references{
Hawkins DM and Kraker JJ. Precision Profile Weighted Deming
Regression for Methods Comparison, on \emph{Arxiv} (2025) \url{doi:10.48550/arXiv.2508.02888}

Efron, B (1982). The jackknife, the bootstrap and other resampling plans.
Society for Industrial and Applied Mathematics.
}
\author{
Douglas M. Hawkins, Jessica J. Kraker \href{mailto:krakerjj@uwec.edu}{krakerjj@uwec.edu}
}
