% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{ppiMEX2017}
\alias{ppiMEX2017}
\title{ppiMEX2017}
\format{A data frame with 8 columns and 101 rows:
\describe{
\item{\code{score}}{PPI score}
\item{\code{nlFood}}{Food poverty line}
\item{\code{nlCapability}}{Capabilities}
\item{\code{nl100}}{National poverty line (100\%)}
\item{\code{nl125}}{National poverty line (125\%)}
\item{\code{nl150}}{National poverty line (150\%)}
\item{\code{ppp125}}{Below $1.25 per day purchasing power parity (2005)}
\item{\code{ppp250}}{Below $2.50 per day purchasing power parity (2005)}
}}
\source{
\url{www.povertyindex.org}
}
\usage{
ppiMEX2017
}
\description{
Poverty Probability Index (PPI) lookup table for Mexico using legacy
definitions
}
\examples{
  # Access Mexico PPI table
  ppiMEX2017

  # Given a specific PPI score (from 0 - 100), get the row of poverty
  # probabilities from PPI table it corresponds to
  ppiScore <- 50
  ppiMEX2017[ppiMEX2017$score == ppiScore, ]

  # Use subset() function to get the row of poverty probabilities corresponding
  # to specific PPI score
  ppiScore <- 50
  subset(ppiMEX2017, score == ppiScore)

  # Given a specific PPI score (from 0 - 100), get a poverty probability
  # based on a specific poverty definition. In this example, the national
  # poverty line definition
  ppiScore <- 50
  ppiMEX2017[ppiMEX2017$score == ppiScore, "nl100"]

}
\keyword{datasets}
