% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotTraitGramMultiPhylo.R
\name{plotTraitGramMultiPhylo}
\alias{plotTraitGramMultiPhylo}
\title{plotTraitGramMultiPhylo}
\usage{
plotTraitGramMultiPhylo(treedata_min, treedata_max, node_est, 
fossils=FALSE, use.paleoclimate=TRUE, paleoclimateUser=NULL, 
layerAge=c(0:20), which.biovars, path="")
}
\arguments{
\item{treedata_min}{tree data object with min estimate of the climate envelope}

\item{treedata_max}{tree data object with max estimate of the climate envelope}

\item{node_est}{the estimate of all the nodes, both min and max. Must be in format [[trees]][[permut]][2,species,trait]}

\item{fossils}{a matrix with four columns of min age, max age, longitude, and latitude, in that order, and rows that are entries for fossil occurrences.}

\item{use.paleoclimate}{if left blank, default North America paleoclimate data is used. If FALSE, user submitted paleoclimate must be provided}

\item{paleoclimateUser}{list of data frames with paleoclimates, must be dataframes with columns: GlobalID, Longitude, Latitude, bio1, bio2,...,bio19. (see \code{getBioclimvars()}).}

\item{layerAge}{vector with the ages of the paleoclimate dataframes, if using user submitted paleoclimate data}

\item{which.biovars}{A vector of the numbers of the bioclimate variables that should be returned. The bioclimate variables number correspond to the Hijmans table at (https://www.worldclim.org/data/bioclim.html).}

\item{path}{path to the directory where the results should be saved}
}
\value{
a trait gram for minimum and maximum of biovariables over a distribution of phylogenetic trees
}
\description{
Combine the node estimates based on random or specified fossil placement and plot them on a phylotrait gram in a specified directory.
}
\details{
plots a traitgram over multiple phylogenetic trees
}
\examples{
data(sampletrees)
data(occurrences)
bounds <- list(sigsq = c(min = 0, max = 1000000))
sample <-sample(sampletrees,5)
\donttest{test_ppgm <- ppgm(occurrences = occurrences,trees = sample, 
model = "BM", which.biovars = c(1), bounds = bounds, 
control = list(niter = 20))}
\dontrun{plotTraitGramMultiPhylo(test_ppgm$treedata_min,
test_ppgm$treedata_max,test_ppgm$node_est)}
}
\seealso{
plotTraitGram
}
\author{
A. Michelle Lawing, Alexandra F. C. Howard
}
