% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check.param.R
\name{check.param}
\alias{check.param}
\title{Internal-use function for quality checking individual parameters}
\usage{
check.param(
  param = NULL,
  type = c("req", "num", "unit", "uniti", "unitii", "pos", "int", "bool", "vals", "min",
    "mini", "vec", "mat", "sum"),
  valslist = NULL,
  min = NULL
)
}
\arguments{
\item{param}{The parameter being checked.}

\item{type}{The expected type of parameter: one of "req", "num", "unit(i)(i)", "pos", "int", "bool", "vals", "min(i)", "vec", "mat", "sum".}

\item{valslist}{If the type is "vals", a list of allowed values.}

\item{min}{If the type is "min" or "mini", a lower bound.}
}
\value{
If the check passes, returns nothing. If the check does not pass, throw an error.
}
\description{
Internal-use function for quality checking individual parameters
}
\examples{
power <- 0.8
check.param(power, "unit")
}
\keyword{internal}
