% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate.R
\name{summary.plcp_multi_sim}
\alias{summary.plcp_multi_sim}
\title{Summarize simulations based on a combination of multiple parameter values}
\usage{
\method{summary}{plcp_multi_sim}(object, para = "time:treatment",
  type = "fixed", model = "correct", alpha = 0.05, ...)
}
\arguments{
\item{object}{A multiple simulation object created with
\code{\link{simulate.plcp_multi}}}

\item{para}{The name of the fixed or random effect that should be summarized.}

\item{type}{Specifies what type of effect \code{para} is; can be either
"random" or "fixed".}

\item{model}{Specifies which model should be summarized. Used when models are
simulated from formulas named "correct" and "wrong".}

\item{alpha}{Indicates the significance level. Default is 0.05 (two-tailed),
one-tailed tests are not yet implemented.}

\item{...}{Optional arguments.}
}
\value{
A \code{data.frame} with class \code{plcp_multi_sim_summary}. Each row
summarizes one of the parameter combinations used in the simulation. It contains
the following columns:
\itemize{
 \item \code{parameter} is the name of the coefficient
 \item \code{M_est} is the mean of the estimates taken over all the simulations.
 \item \code{theta} is the population parameter values specified with \code{study_parameters}
 \item \code{est_rel_bias} is the relative bias of the estimate
 \item \code{M_se} is the mean estimated standard error taken over all the simulations.
 \item \code{SD_est} is the empirical standard error; i.e. the standard
 deviation of the distribution of the generated estimates
 \item \code{se_rel_bias} is the relative bias of the standard error.
 \item \code{power} is the empirical power of the Wald Z test, i.e. the proportion
 of simulated p-values < alpha
 \item \code{power_satt} is the empirical power of the Wald \emph{t} test using
  Satterthwaite's degree of freedom approximation
 \item \code{satt_NA} is the proportion of Satterthwaite's approximations that failed.
 \item \code{prop_zero} is the proportion of the simulated estimates that
 are zero; only shown for random effects
}
}
\description{
Summarize simulations based on a combination of multiple parameter values
}
