% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting-power.R
\name{plot_power_heatmap}
\alias{plot_power_heatmap}
\title{Plot Bayesian Power / Assurance Heatmap (Multi-Effect Grid Friendly)}
\usage{
plot_power_heatmap(
  power_results,
  power_metric = c("direction", "threshold", "rope"),
  x_effect = NULL,
  y_effect = "n",
  facet_by = NULL,
  title = NULL,
  subtitle = NULL
)
}
\arguments{
\item{power_results}{Output from a \code{brms_inla_power} function.}

\item{power_metric}{Which metric to plot: \code{"direction"}, \code{"threshold"}, or \code{"rope"}.}

\item{x_effect}{Name of effect grid column for x-axis (default = first effect).}

\item{y_effect}{Name of effect grid column for y-axis (default = "n").}

\item{facet_by}{Optional effect grid column(s) to facet by.}

\item{title, subtitle}{Optional plot labels.}
}
\value{
A ggplot object.
}
\description{
Heatmap of assurance for a chosen metric across two selected effect grid variables and sample sizes.
}
