% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test_indirect_effects.R
\name{test_k_indirect_effects}
\alias{test_k_indirect_effects}
\title{Test Several Indirect Effects}
\usage{
test_k_indirect_effects(
  fit = fit,
  x = NULL,
  m = NULL,
  y = NULL,
  mc_ci = TRUE,
  mc_out = NULL,
  boot_ci = FALSE,
  boot_out = NULL,
  check_post_check = TRUE,
  ...,
  omnibus = c("no", "all_sig", "at_least_one_sig", "at_least_k_sig"),
  at_least_k = 1,
  fit_name = "fit",
  get_map_names = FALSE,
  get_test_name = FALSE
)
}
\arguments{
\item{fit}{The fit object, to be
passed to \code{\link[manymome:cond_indirect]{manymome::indirect_effect()}}.}

\item{x}{The name of the \code{x}-variable,
the predictor.}

\item{m}{Must be a list of character
vectors. Each character vector stores the
name(s) of mediator(s) along a path.
The path
moves from the first mediator in the
vector to the last mediator in the
vector. If \code{NULL}, the stored paths
will be used, which are all the
indirect paths in the model between
\code{x} and \code{y}, by default.}

\item{y}{The name of the \code{y}-variable,
the outcome variable.}

\item{mc_ci}{Logical. If \code{TRUE}, the
default, Monte Carlo confidence
intervals will be formed. This argument
and \code{boot_ci} cannot be both \code{TRUE}.}

\item{mc_out}{The pre-generated
Monte Carlo estimates generated by
\link[manymome:do_mc]{manymome::do_mc}, stored in
a \code{power4test} object. Users should
not set this argument and should let
\code{\link[=power4test]{power4test()}} to set it automatically.}

\item{boot_ci}{Logical. If \code{TRUE},
the default, nonparametric bootstrap
confidence intervals will be formed.
This argument
and \code{mc_ci} cannot be both \code{TRUE}.}

\item{boot_out}{The pre-generated
bootstrap estimates generated by
\link[manymome:do_boot]{manymome::do_boot}, stored in
a \code{power4test} object. Users should
not set this argument and should let
\code{\link[=power4test]{power4test()}} to set it automatically.}

\item{check_post_check}{Logical. If
\code{TRUE}, the default, and the model
is fitted by \code{lavaan}, the test
will be conducted only if the model
passes the \code{post.check} conducted
by \code{\link[lavaan:lavInspect]{lavaan::lavInspect()}} (with
\code{what = "post.check"}).}

\item{...}{Additional arguments to
be passed to \code{\link[manymome:cond_indirect]{manymome::many_indirect_effects()}}.}

\item{omnibus}{If \code{"no"}, the default,
then the test results for all paths
are stored. If \code{"all_sig"}, then
only one row of test is stored, and
the test is declared significant if
\emph{all} paths are significant. If
\code{"at_least_one_sig"}, then only
one row of test is stored, and the
test is declared significant if
at least one of the paths is
significant. If \code{"at_least_k_sig"},
then only one row of test is stored,
and the test is declared significant
if at least \code{k} of the paths is
significant, \code{k} determined by the
argument \code{at_least_k}.}

\item{at_least_k}{The minimum number
of paths required to be significant
for the omnibus test to be considered
significant. Used when
\code{omnibus} is \code{"at_least_k_sig"}.}

\item{fit_name}{The name of the
model fit object to be extracted.
Default is \code{"fit"}. Used only when
more than one model is fitted in
each replication. This should be
the name of the model on which the
test is to be conducted.}

\item{get_map_names}{Logical. Used
by \code{\link[=power4test]{power4test()}} to determine how
to extract stored information and
assign them to this function. Users
should not use this argument.}

\item{get_test_name}{Logical. Used
by \code{\link[=power4test]{power4test()}} to get the default
name of this test. Users should not
use this argument.}
}
\value{
In its normal usage, it returns
a data frame with the
following columns:
\itemize{
\item \code{est}: The estimated
indirect effect for each path.
\item \code{cilo} and \code{cihi}: The
lower and upper limits of the
confidence interval (95\% by
default), respectively,
for each indirect effect
\item \code{sig}: Whether a test by confidence
interval is significant (\code{1}) or
not significant (\code{0}).
\item \code{test_label}: A column of labels
generated to label the indirect
effects.
}

If \code{omnibus} is \code{"all_sig"} or
\verb{"at_least_one"sig"}, then
the data frame has only one row,
and the columns \code{"est"}, \code{"cilo"},
and \code{"cihi"} are \code{NA}. The column
\code{sig} is determined by whether
all paths are significant (\code{"all_sig"})
or whether at least one path is
significant (\code{"at_least_one_sig"}).
}
\description{
Test several indirect effects
for a \code{power4test} object.
}
\details{
This function is to be used in
\code{\link[=power4test]{power4test()}} for testing an
indirect effect, by setting it
to the \code{test_fun} argument.

It uses \code{\link[manymome:cond_indirect]{manymome::many_indirect_effects()}}
to do the test. It can be used on
models fitted by \code{\link[lavaan:sem]{lavaan::sem()}}
or fitted by a sequence of calls
to \code{\link[stats:lm]{stats::lm()}}, although only
nonparametric bootstrap confidence
interval is supported for models
fitted by regression using
\code{\link[stats:lm]{stats::lm()}}.
}
\examples{

# Specify the model

model_simple_med <-
"
m1 ~ x
m2 ~ x
y ~ m1 + m2 + x
"

# Specify the population values

model_simple_med_es <-
"
y ~ m1: s
m1 ~ x: m
y ~ m2: s
m2 ~ x: l
y ~ x: n
"

# Simulate the data

sim_only <- power4test(nrep = 5,
                       model = model_simple_med,
                       pop_es = model_simple_med_es,
                       n = 100,
                       R = 100,
                       do_the_test = FALSE,
                       iseed = 1234)

# Do the test in each replication

test_ind <- power4test(object = sim_only,
                       test_fun = test_k_indirect_effects,
                       test_args = list(x = "x",
                                        y = "y",
                                        mc_ci = TRUE))
print(test_ind,
      test_long = TRUE)

# Set omnibus = "all_sig" to declare
# significant only if all paths are
# significant

test_ind_all_sig <- power4test(
                       object = sim_only,
                       test_fun = test_k_indirect_effects,
                       test_args = list(x = "x",
                                        y = "y",
                                        mc_ci = TRUE,
                                        omnibus = "all_sig"))
print(test_ind_all_sig,
      test_long = TRUE)

}
\seealso{
\code{\link[=power4test]{power4test()}}
}
