% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tmGrowNoExtDT.R
\name{genGrowTree}
\alias{genGrowTree}
\title{Generation of rooted binary trees under tree growing models (no extinction)}
\usage{
genGrowTree(
  n,
  STARTING_RATE = 1,
  STARTING_TRAIT = 10,
  ZETA = 1,
  SIGMA = 0,
  childRates,
  otherRates,
  childTraits = NULL,
  otherTraits = NULL,
  use_built_in = NULL
)
}
\arguments{
\item{n}{Integer value that specifies the desired number of leaves, i.e.,
vertices with in-degree 1 and out-degree 0.}

\item{STARTING_RATE}{Positive numeric value (default = 1) which specifies the
initial rate at which the speciation events occur (has only influence on the
edge length, not on the tree topology).}

\item{STARTING_TRAIT}{Numeric value (default = 10) which specifies
the initial state of a trait.}

\item{ZETA}{Constant non-negative numeric value (default = 1) which can
influence the speciation rates. Can also be a vector if used as such when
defining the functions \code{childRates}, \code{otherRates},
\code{childTraits}, and \code{otherTraits}.}

\item{SIGMA}{Constant positive numeric value (default = 0) which can influence
the speciation rates. Can also be a vector if used as such when defining the
functions \code{childRates}, \code{otherRates}, \code{childTraits}, and
\code{otherTraits}.}

\item{childRates}{A function that generates two speciation rates for the
children emerging from a speciation event based on various factors. \cr
Necessary if \code{use_built_in} is not specified.
\code{childTraits} works similarly but is executed before
\code{childRates}. \cr
All available parameters are: \cr
\itemize{
\item the starting rate \code{sr},  \cr
\item the starting trait value \code{st},  \cr
\item the parent's rate \code{pr},  \cr
\item the parent's trait value \code{pt},  \cr
\item the children's trait values \code{ct} (vector \code{ct[1]} and
\code{ct[2]}), \cr
\item the parameters zeta \code{ze}  \cr
\item and sigma \code{si}. \cr\cr
All parameters have to appear in the function definition but not
necessarily in the body of the function. Trait values are NA, if
\code{childTraits} and \code{otherTraits} is not given.\cr
Example: \cr
\code{function (sr, st, pr, pt, ct, ze, si) return(c(pr*ze,
pr*(1-ze)))} for biased speciation.
}}

\item{otherRates}{A function that generates a new speciation rate for all
leaves not affected by the speciation event (all but parent and children)
based on various factors. The function is applied after the speciation event,
i.e., after \code{childRates/Traits}.\cr
Necessary if \code{use_built_in} is not specified.
\code{otherTraits} works similarly. \cr
All available parameters are: \cr
\itemize{
\item the starting rate \code{sr},  \cr
\item the starting trait value \code{st},  \cr
\item the leaf's old rate \code{or},  \cr
\item the leaf's old trait value \code{ot}, \cr
\item the parameters zeta \code{ze}  \cr
\item and sigma \code{si}. \cr\cr
All parameters have to appear in the function definition but not
necessarily in the body of the function. Trait values are NA, if
\code{childTraits} and \code{otherTraits} is not given. \cr
Example: \cr
\code{function (sr, st, or, ot, ze, si) return(or*ze)} for
age-step-based fertility.
}}

\item{childTraits}{An optional function (default = NULL) that generates two
trait values for the children emerging from a speciation event based on
various factors. \cr
See \code{childRates} for available parameters (except \code{ct}) and
explanations. Not necessary; is only applied if not NULL.\cr
Example: \cr
\code{function (sr, st, pr, pt, ze, si)
return(c(0, 0))} for age.}

\item{otherTraits}{An optional function (default = NULL) that generates a new
trait value for all leaves not affected by the speciation event (all but
parent and children) based on various factors. \cr
See \code{otherRates} for available parameters and explanations. \cr
Not necessary; is only applied if not NULL.\cr
Example:\cr
\code{function (sr, st, or, ot, ze, si) return(ot+1)}
for discrete age (age in time steps).}

\item{use_built_in}{Optional (default = NULL): Character specifying which of
the already implemented models should be used. Overwrites \code{childRates},
\code{otherRates}, \code{childTraits}, and \code{otherTraits}.\cr
Here is a list of available models with their (abbreviated) underlying
functions given in parentheses  (in order \code{childRates},
\code{otherRates}; then \code{childTraits} and \code{otherTraits}
if necessary): \cr
\itemize{
\item "DCO_sym": Symmetric direct-children-only, \code{ZETA}>0
(c(sr ze, sr ze), sr) \cr
\item "DCO_asym": Asymmetric direct-children-only, \code{ZETA}>0
(c(sz, pr), sr) \cr
\item "IF_sym": Symmetric inherited fertility, \code{ZETA}>0
(c(pr ze, pr ze), or) \cr
\item "IF_asym": Asymmetric inherited fertility, \code{ZETA}>0
(c(pr ze, pr), or) \cr
\item "IF-diff": Unequal fertility inheritance, \code{ZETA}>=1
(c(2 pr ze / (ze+1), 2 pr / (ze+1)), or)\cr
\item "biased": Biased speciation, \code{ZETA} >=0 and <=1
(c(pr ze, pr (1-ze)), or)\cr
\item "ASB": Age-step-based fertility, \code{ZETA}>0
(c(sr, sr), or ze)\cr
\item "simpleBrown_sym": Symmetric simple Brownian, \code{SIGMA}> =0
(c(max\{pr+ rnorm(1, mean=0, sd=si),1e-100\},
max\{pr+ rnorm(1, mean=0, sd=si),1e-100\}), or) \cr
\item "simpleBrown_asym": Asymmetric simple Brownian, \code{SIGMA}>=0
(c(max\{pr+ rnorm(1, mean=0, sd=si),1e-100\}, pr), or) \cr
\item "lin-Brown_sym": Sym. punctuated(-intermittent) linear-Brownian,
\code{SIGMA} vector with two values >=0 \cr
(c(10^(log(ct[1])+ rnorm(1, mean=0, sd=si[1])),
10^(log(ct[2])+ rnorm(1, mean=0, sd=si[1]))), or; \cr
c(max\{pt + rnorm(1, mean=0, sd=si[2]),1e-100\},
max\{pt + rnorm(1, mean=0, sd=si[2]),1e-100\}), ot) \cr
\item "lin-Brown_asym": Asym. punctuated(-intermittent) linear-Brownian,
\code{SIGMA} vector with two values >=0 \cr
(c(10^(log(ct[1])+ rnorm(1, mean=0, sd=si[1])), pr), or; \cr
c(max\{pt + rnorm(1, mean=0, sd=si[2]),1e-100\}, pt, ot) \cr
\item "lin-Brown-bounded_sym": Bounded sym. punctuated(-intermittent)
linear-Brownian,  \code{SIGMA} vector with two values >=0,
\code{STARTING_TRAIT} is automatically set to 10 \cr
(c(10^(log(ct[1])+ rnorm(1, mean=0, sd=si[1])),
10^(log(ct[2])+ rnorm(1, mean=0, sd=si[1]))), or; \cr
c(min\{max\{pt + rnorm(1, mean=0, sd=si[2]),1e-100\},20\},
min\{max\{pt + rnorm(1, mean=0, sd=si[2]),1e-100\},20\}), ot) \cr
\item "lin-Brown-bounded_asym": Bounded asym. punctuated(-intermittent)
linear-Brownian, \code{SIGMA} vector with two values >=0 \cr
(c(10^(log(ct[1])+ rnorm(1, mean=0, sd=si[1])), pr), or; \cr
c(min\{max\{pt + rnorm(1, mean=0, sd=si[2]),1e-100\},20\}, pt), ot) \cr
\item "log-Brown_sym": Sym. punctuated(-intermittent) log-Brownian,
\code{SIGMA} vector with two values >=0 \cr
(c(10^(log(ct[1])+ rnorm(1, mean=0, sd=si[1])),
10^(log(ct[2])+ rnorm(1, mean=0, sd=si[1]))), or; \cr
c(10^(log(pt)+ rnorm(1, mean=0, sd=si[2])),
10^(log(pt)+ rnorm(1, mean=0, sd=si[2]))), ot) \cr
\item "log-Brown_asym": Asym. punctuated(-intermittent) log-Brownian,
\code{SIGMA} vector with two values >=0 \cr
(c(10^(log(ct[1])+ rnorm(1, mean=0, sd=si[1])), pr), or; \cr
10^(c(log(pt)+ rnorm(1, mean=0, sd=si[2])), pt), ot)
}}
}
\value{
\code{genGrowTree} A single tree of class \code{phylo} is
returned.
}
\description{
\code{genGrowTree} - Generates a rooted binary tree in \code{phylo}
format with the given number of \code{n} leaves under a specified
discrete-time tree growing model without extinction.
These tree growing models act at the leaves by varying their speciation
rates according to a parameter \code{ZETA} or variance \code{SIGMA}. They
may also depend on so-called trait values of the leaves (e.g., continuous or
discrete age, or another numeric trait that affects fitness).\cr
You may choose an already built-in model (see \code{use_built_in}) or
specify a (new) model by defining how the rates (and optionally traits)
change in every time step (see parameters \code{childRates} and
\code{otherRates} as well as \code{childTraits} and
\code{otherTraits}; see also Table 5 of the supplementary material of
the corresponding manuscript). \cr
Due to the restrictions of the \code{phylo} or \code{multiphylo} format
the number of leaves must be at least 2 since there must be at
least one edge.
}
\examples{
genGrowTree(n = 5, use_built_in = "IF_sym", ZETA = 2)
}
\references{
\itemize{
\item S. J. Kersting, K. Wicke, and M. Fischer. Tree balance in phylogenetic models.
arXiv:2406.05185, 2024.
\item S. J. Kersting, K. Wicke, and M. Fischer. Tree balance in phylogenetic
models: Supplementary material. https://tinyurl.com/278cwdh8, 2024.
\item M. G. B. Blum and O. Francois. On statistical tests of phylogenetic tree
imbalance: the Sackin and other indices revisited. Mathematical Biosciences,
195(2):141–153, 2005.
\item S. B. Heard. Patterns in phylogenetic tree balance with variable and
evolving speciation rates. Evolution, 50(6):2141–2148, 1996.
\item S. J. Kersting. Genetic programming as a means for generating improved
tree balance indices (Master’s thesis, University of Greifswald), 2020.
\item M. Kirkpatrick and M. Slatkin. Searching for evolutionary patterns in the
shape of a phylogenetic tree. Evolution, 47(4):1171–1181, 1993.
}
}
\author{
Sophie Kersting
}
